# 帳票設計書 9-GangliaSink メトリクスレポート

## 概要

本ドキュメントは、Apache Spark の MetricsSystem における GangliaSink が出力する Ganglia 形式メトリクスレポートの設計書である。Dropwizard Metrics ライブラリの GangliaReporter および gmetric4j ライブラリの GMetric を利用し、Spark の各コンポーネントのメトリクス情報を Ganglia モニタリングサーバへ定期的にネットワーク経由で送信する。マルチキャストとユニキャストの両方のアドレッシングモードに対応している。

### 本帳票の処理概要

GangliaSink メトリクスレポートは、Spark の内部メトリクスデータを Ganglia モニタリングシステムへ定期送信する帳票機能である。

**業務上の目的・背景**：Ganglia は大規模分散システム向けのスケーラブルなモニタリングシステムであり、HPC（High Performance Computing）環境やクラスタ環境で広く利用されている。既に Ganglia ベースのモニタリングインフラを持つ組織が、Spark クラスタのメトリクスを既存の Ganglia ダッシュボードに統合する際に利用する。マルチキャストによる効率的なメトリクス配信が可能であり、大規模クラスタ環境に適している。

**帳票の利用シーン**：(1) Ganglia ベースの既存モニタリングインフラに Spark メトリクスを統合する場合、(2) HPC 環境で Spark を運用する場合、(3) マルチキャスト配信による効率的なメトリクス収集を行う場合。

**主要な出力内容**：
1. Gauge メトリクス - Ganglia のメトリクスタイプとして送信
2. Counter メトリクス - Ganglia のメトリクスタイプとして送信
3. Histogram メトリクス - 統計値群を個別メトリクスとして送信
4. Meter メトリクス - レート情報を個別メトリクスとして送信
5. Timer メトリクス - 統計値とレート情報を個別メトリクスとして送信

**帳票の出力タイミング**：MetricsSystem の start() 呼び出し時に定期送信が開始され、設定された間隔（デフォルト10秒）で自動送信される。

**帳票の利用者**：Spark クラスタ管理者、HPC 運用チーム、Ganglia 管理者。

## 帳票種別

メトリクスレポート（ネットワーク送信型の時系列データ、マルチキャスト/ユニキャスト対応）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | 設定ファイル駆動 | N/A | metrics.properties の設定により Ganglia サーバへ自動送信 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Ganglia gmetric プロトコル |
| 用紙サイズ | N/A（ネットワーク送信） |
| 向き | N/A |
| ファイル名 | N/A（ネットワーク送信） |
| 出力方法 | マルチキャストまたはユニキャスト UDP で Ganglia サーバへ送信 |
| 文字コード | N/A（バイナリプロトコル） |

### Ganglia 固有設定

| 項目 | 内容 |
|-----|------|
| アドレッシングモード | MULTICAST（デフォルト）/ UNICAST |
| TTL | マルチキャスト TTL（デフォルト: 1） |
| dmax | メトリクスの最大保持時間（デフォルト: 0 = 無制限） |
| 時間単位（Duration） | ミリ秒（MILLISECONDS） |
| レート単位 | 秒あたり（SECONDS） |

## 帳票レイアウト

### レイアウト概要

Ganglia gmetric プロトコルに従い、各メトリクスを個別のデータポイントとして送信する。Ganglia UI 上ではグラフとして可視化される。

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | ヘッダーなし | gmetric プロトコルにヘッダーは存在しない | N/A | N/A |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | メトリクス名 | MetricRegistry のキー名 | MetricRegistry | 文字列 | 可変 |
| 2 | メトリクス値 | 各メトリクス固有の値 | MetricRegistry | 数値 | 可変 |
| 3 | メトリクスタイプ | Ganglia のデータタイプ | GangliaReporter | Ganglia 型 | 可変 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| N/A | フッターなし | N/A | N/A | N/A |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| MetricRegistry 登録 | MetricRegistry に登録されている全メトリクスが対象 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| N/A | Ganglia サーバ側で管理 | N/A |

### 改ページ条件

ネットワーク送信のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを参照しない。

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A（MetricRegistry） | メトリクスデータの取得元 | N/A |

### テーブル別参照項目詳細

#### MetricRegistry（インメモリ）

| 参照項目 | 帳票項目との対応 | 取得条件 | 備考 |
|---------|----------------|---------|------|
| Gauges | Gauge メトリクス送信 | registry.getGauges() | 全 Gauge |
| Counters | Counter メトリクス送信 | registry.getCounters() | 全 Counter |
| Histograms | Histogram メトリクス送信 | registry.getHistograms() | 全 Histogram |
| Meters | Meter メトリクス送信 | registry.getMeters() | 全 Meter |
| Timers | Timer メトリクス送信 | registry.getTimers() | 全 Timer |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| レート変換 | 元値 / 秒 | Dropwizard 既定 | convertRatesTo(TimeUnit.SECONDS) |
| Duration変換 | 元値(ns) -> ms | Dropwizard 既定 | convertDurationsTo(TimeUnit.MILLISECONDS) |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[MetricsSystem.start] --> B[GangliaSink.start]
    B --> C[GangliaReporter.start - 定期スケジュール登録]
    C --> D{定期タイマー発火}
    D --> E[GangliaReporter.report]
    E --> F[MetricRegistry からメトリクス取得]
    F --> G{アドレッシングモード}
    G -->|MULTICAST| H[マルチキャスト UDP で送信]
    G -->|UNICAST| I[ユニキャスト UDP で送信]
    H --> D
    I --> D
    J[MetricsSystem.stop] --> K[GangliaSink.stop]
    K --> L[GangliaReporter.stop]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| host 未設定 | property に host が設定されていない | Exception: Ganglia sink requires 'host' property. | host 設定を追加 |
| port 未設定 | property に port が設定されていない | Exception: Ganglia sink requires 'port' property. | port 設定を追加 |
| ポーリング間隔エラー | ポーリング間隔が1秒未満 | IllegalArgumentException | 設定値を1秒以上に変更 |
| ネットワークエラー | Ganglia サーバに送信できない | GangliaReporter 内部のエラー | ネットワーク設定・サーバ状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | メトリクス数に依存 |
| 目標出力時間 | 定期間隔内に送信完了（デフォルト10秒以内） |
| 同時出力数上限 | 1（単一スレッドでの定期レポート） |

## セキュリティ考慮事項

- Ganglia との通信は暗号化されていないため、機密性の高いメトリクスを送信する場合はネットワーク分離を検討すること
- マルチキャストモードではネットワークセグメント内の全ホストがメトリクスを受信可能なため、TTL 設定とネットワーク構成に注意
- このモジュールは spark-ganglia-lgpl コネクタとして LGPL ライセンスで提供されている

## 備考

- 設定は `metrics.properties` ファイルで行う。設定例：
  ```
  *.sink.ganglia.class=org.apache.spark.metrics.sink.GangliaSink
  *.sink.ganglia.host=239.2.11.71
  *.sink.ganglia.port=8649
  *.sink.ganglia.period=10
  *.sink.ganglia.unit=SECONDS
  *.sink.ganglia.mode=MULTICAST
  *.sink.ganglia.ttl=1
  *.sink.ganglia.dmax=0
  ```
- host と port は必須設定項目
- GangliaSink は `connector/spark-ganglia-lgpl` モジュールに格納されており、LGPL ライセンスのため Spark コアとは分離されている
- GMetric ライブラリ（gmetric4j）を使用しており、Ganglia 3.1.x 以降に対応
- `private[spark]` が付与されていない（他の Sink と異なり）、パッケージ外からも利用可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Sink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` | Sink トレイト定義（行20-24） |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | MetricsSystem.scala | `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` | registerSinks()（行199-240）での Sink インスタンス化 |

#### Step 3: GangliaSink の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GangliaSink.scala | `connector/spark-ganglia-lgpl/src/main/scala/org/apache/spark/metrics/sink/GangliaSink.scala` | クラス全体（行30-94）を通読。他の Sink と比べて mode（MULTICAST/UNICAST）、ttl、dmax の設定が特徴 |

**主要処理フロー**:
- **行30-31**: Properties と MetricRegistry をコンストラクタ引数として受け取る
- **行32-49**: デフォルト値と設定キーの定義（period=10, unit=SECONDS, mode=MULTICAST, ttl=1, dmax=0）
- **行51**: propertyToOption() ヘルパーメソッド
- **行53-59**: host と port の必須チェック（未設定時は Exception）
- **行61-72**: host, port, ttl, dmax, mode, pollPeriod, pollUnit の読み込み
- **行74**: MetricsSystem.checkMinimalPollingPeriod() でポーリング間隔検証
- **行76**: GMetric インスタンス生成（host, port, mode, ttl）
- **行77-81**: GangliaReporter を構築。Duration はミリ秒、Rate は秒、dmax 付き
- **行83-85**: start() で定期レポート開始
- **行87-89**: stop() で停止
- **行91-93**: report() で即時レポート

### プログラム呼び出し階層図

```
MetricsSystem.start()
    |
    +-- registerSinks()
    |       +-- GangliaSink.<init>(properties, registry)
    |               +-- host/port 必須チェック
    |               +-- MetricsSystem.checkMinimalPollingPeriod()
    |               +-- new GMetric(host, port, mode, ttl)
    |               +-- GangliaReporter.forRegistry(registry)
    |                       .withDMax(dmax)
    |                       .build(ganglia)
    |
    +-- sinks.foreach(_.start())
            +-- GangliaSink.start()
                    +-- GangliaReporter.start(pollPeriod, pollUnit)
                            +-- [定期スケジュール] GangliaReporter.report()
                                    +-- GMetric でメトリクス送信
                                    +-- MULTICAST/UNICAST UDP
```

### データフロー図

```
[入力]                       [処理]                         [出力]

MetricRegistry           GangliaSink                   Ganglia サーバ
(Gauges,                 +-- GangliaReporter            host:port
 Counters,                   +-- GMetric                (MULTICAST/UNICAST)
 Histograms,                     (host, port,
 Meters,                          mode, ttl)
 Timers)                     +-- withDMax(dmax)

Properties               設定読み込み
(host, port, period,     +-- 必須チェック(host, port)
 unit, mode, ttl, dmax)  +-- モード選択(MULTICAST/UNICAST)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Sink.scala | `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` | ソース | Sink トレイト定義 |
| GangliaSink.scala | `connector/spark-ganglia-lgpl/src/main/scala/org/apache/spark/metrics/sink/GangliaSink.scala` | ソース | Ganglia 送信 Sink の実装 |
| MetricsSystem.scala | `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` | ソース | Sink の登録・管理・起動 |
