---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-StatsReportListener 統計サマリー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）。StatsReportListener は Spark 独自実装であるため、全ロジックがソースコードから確認可能。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/StatsReportListener.scala` 行33-200
- E-02: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行11（No.10 の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListener を継承し Logging を mix-in | E-01（行33: extends SparkListener with Logging） | ○ |
| C-02 | @DeveloperApi アノテーション付き | E-01（行32: @DeveloperApi） | ○ |
| C-03 | taskInfoMetrics バッファで TaskInfo/TaskMetrics ペアを蓄積 | E-01（行37: mutable.Buffer[(TaskInfo, TaskMetrics)]） | ○ |
| C-04 | onTaskEnd で info/metrics が null でなければバッファに追加 | E-01（行39-45） | ○ |
| C-05 | onStageCompleted でステージ情報をログ出力 | E-01（行49-50: logInfo, getStatusDetail） | ○ |
| C-06 | task runtime 分布を showMillisDistribution で出力 | E-01（行51: showMillisDistribution("task runtime:", ...)） | ○ |
| C-07 | shuffle bytes written 分布を showBytesDistribution で出力 | E-01（行54-55） | ○ |
| C-08 | fetch wait time 分布を showMillisDistribution で出力 | E-01（行58-59） | ○ |
| C-09 | remote bytes read 分布を showBytesDistribution で出力 | E-01（行60-61） | ○ |
| C-10 | task result size 分布を showBytesDistribution で出力 | E-01（行62-63） | ○ |
| C-11 | RuntimePercentage を計算 | E-01（行66-68） | ○ |
| C-12 | executor/fetch/other 時間割合を showDistribution で出力 | E-01（行69-73） | ○ |
| C-13 | ステージ完了後に taskInfoMetrics.clear() | E-01（行74） | ○ |
| C-14 | パーセンタイル配列 = [0, 5, 10, 25, 50, 75, 90, 95, 100] | E-01（行93: val percentiles = Array[Int](0, 5, 10, 25, 50, 75, 90, 95, 100)） | ○ |
| C-15 | probabilities = percentiles / 100.0 | E-01（行94: val probabilities = percentiles.map(_ / 100.0)） | ○ |
| C-16 | getStatusDetail でステージ詳細を生成 | E-01（行77-86） | ○ |
| C-17 | millisToString で時間単位を自動変換 | E-01（行174-186: hours/min/s/ms の条件分岐） | ○ |
| C-18 | hours = minutes * 60, minutes = seconds * 60, seconds = 1000L | E-01（行167-169） | ○ |
| C-19 | RuntimePercentage.apply で exec/fetch/other を計算 | E-01（行192-199） | ○ |
| C-20 | exec = (executorRunTime - fetchWaitTime) / totalTime | E-01（行196） | ○ |
| C-21 | fetch = fetchWaitTime / totalTime | E-01（行195） | ○ |
| C-22 | other = 1.0 - (exec + fetch) | E-01（行197） | ○ |
| C-23 | showDistribution でパーセンタイルのタブ区切り出力 | E-01（行112-118） | ○ |
| C-24 | extractLongDistribution で Long 値を Distribution に変換 | E-01（行104-110） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。StatsReportListener は Spark 独自実装であり、全ロジックがソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 全主張にソースコードレベルの根拠あり
- 0: RuntimePercentage のゼロ除算の可能性（totalTime=0 の場合）に関する記述がエラー処理に含まれている

## 6) レビュアーチェックリスト（最小）
- [ ] パーセンタイル配列の値が正確に記述されているか確認
- [ ] RuntimePercentage の計算式が正確か確認（exec + fetch + other = 1.0）
- [ ] millisToString の単位変換閾値が正確か確認
- [ ] onTaskEnd の null チェック条件が正確か確認
- [ ] onStageCompleted で出力される統計項目の順序が正確か確認
