---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：12-AllJobsPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **デフォルトポート4040**：コードからの直接確認ができていない
  2. **タイムライン設定パラメータ名の正確性**：spark.ui.timeline.* の正式名称確認が望ましい

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行40（クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行44-46（タイムライン設定）
- E-03: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行278-425（render メソッド）
- E-04: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行71-124（makeJobEvent）
- E-05: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行126-171（makeExecutorEvent）
- E-06: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行244-276（jobsTable）
- E-07: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行440-506（JobDataSource）
- E-08: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行508-618（JobPagedTable）
- E-09: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行553-564（テーブルヘッダー定義）
- E-10: `core/src/main/scala/org/apache/spark/ui/jobs/JobsTab.scala` 行29-65（JobsTab 定義）
- E-11: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` 行268-275（エラーハンドリング）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AllJobsPage は WebUIPage("") を継承する | E-01 | ○ |
| C-02 | タイムライン表示は UI_TIMELINE_ENABLED で制御される | E-02 | ○ |
| C-03 | ジョブを SUCCEEDED/FAILED/その他 で3グループに分類 | E-03（行288-297） | ○ |
| C-04 | store.jobsList(null) で全ジョブを取得 | E-03（行288） | ○ |
| C-05 | スケジューリングモードは environmentInfo から取得 | E-03（行318-321） | ○ |
| C-06 | makeTimeline でジョブとExecutorのタイムラインを生成 | E-04, E-05 | ○ |
| C-07 | テーブルカラムは Job Id, Description, Submitted, Duration, Stages, Tasks | E-09 | ○ |
| C-08 | ソートは Job Id, Description, Submitted, Duration に対応 | E-07（行490-504） | ○ |
| C-09 | Stages/Tasks カラムはソート不可 | E-07（行495-496） | ○ |
| C-10 | ジョブキルは killEnabled と securityManager で制御 | E-10（行50-63） | ○ |
| C-11 | テーブル描画エラーはcatch句で処理される | E-11 | ○ |
| C-12 | UNKNOWN ステータスのジョブはタイムラインに表示されない | E-04（行73-74） | ○ |
| C-13 | 完了ジョブ数の表示で制限メッセージが出る場合がある | E-03（行311-315） | ○ |
| C-14 | タイムラインジョブ数は MAX_TIMELINE_JOBS で制限 | E-02, E-04（行77） | ○ |
| C-15 | ページネーション機能を持つ | E-08 | ○ |
| C-16 | ジョブの説明テキストは HTML エスケープされる | E-04（行97-99） | ○ |
| C-17 | UIUtils.headerSparkPage でページ構成される | E-03（行423-424） | ○ |
| C-18 | デフォルトポートは 4040 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Web UI のデフォルトポート番号 4040 はコードからの直接確認ができていない
  - 候補：SparkUI.scala / spark.ui.port のデフォルト値定義 / Spark 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードからの読み取りが正確で信頼性が高い
- 0: 低リスク - テーブル構造とカラム定義はコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Web UI のデフォルトポート番号が正しいか確認
- [ ] タイムライン設定パラメータ名が公式ドキュメントと一致するか確認
- [ ] ジョブキルのセキュリティ制御が適切に記載されているか確認
