---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：13-JobPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **StageTableBase のカラム構成**：StageTableBase.scala を直接読んでいないため、明細部のカラム一覧の正確性は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行36（クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行224-529（render メソッド）
- E-03: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行229-236（jobWithAssociatedSql）
- E-04: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行238-312（ステージデータ取得とデフォルト値）
- E-05: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行315-332（ステージ状態分類）
- E-06: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行336-341（Pending/Skipped判定）
- E-07: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行343-358（StageTableBase 生成）
- E-08: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行450-456（DAG 可視化）
- E-09: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行65-105（makeStageEvent）
- E-10: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行107-151（makeExecutorEvent）
- E-11: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行38-39（タイムライン設定）
- E-12: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` 行527-528（headerSparkPage呼び出し）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JobPage は WebUIPage("job") を継承する | E-01 | ○ |
| C-02 | id パラメータが必須 | E-02（行225-226） | ○ |
| C-03 | jobWithAssociatedSql でジョブデータとSQL実行IDを取得 | E-03 | ○ |
| C-04 | ステージ情報が未受信の場合はデフォルト StageData を使用 | E-04 | ○ |
| C-05 | ステージは submissionTime/completionTime/status で分類される | E-05 | ○ |
| C-06 | ジョブ完了時は Pending ステージが Skipped として表示 | E-06 | ○ |
| C-07 | StageTableBase で各ステージテーブルを生成 | E-07 | ○ |
| C-08 | DAG 可視化は operationGraphForJob で取得 | E-08 | ○ |
| C-09 | タイムラインのステージ数上限は UI_TIMELINE_STAGES_MAXIMUM | E-11 | ○ |
| C-10 | ステータスに応じた色分けがタイムラインに適用される | E-09（行73, 86） | ○ |
| C-11 | showVisualization=true で DAG 表示有効化 | E-12 | ○ |
| C-12 | ジョブ未発見時は "No information" メッセージ表示 | E-03（行231-235） | ○ |
| C-13 | DAG 情報なし時は "No DAG visualization" メッセージ表示 | E-08（行453-455） | ○ |
| C-14 | SQL クエリリンクは /SQL/execution/?id= 形式 | E-02（行385-388） | ○ |
| C-15 | makeExecutorEvent でExecutorタイムラインを生成 | E-10 | ○ |
| C-16 | StageTableBase のカラムは Stage Id, Description, Submitted, Duration, Tasks, Input, Output, Shuffle Read, Shuffle Write | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- StageTableBase.scala のソースコードを直接読んでいないため、テーブルカラムの正確な構成は推定
  - 候補：StageTableBase.scala を直接参照して確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ジョブサマリーとステージ分類ロジックはソースコードから直接確認済み
- 1: 中リスク - StageTableBase のカラム構成は推定のため要確認

## 6) レビュアーチェックリスト（最小）
- [ ] StageTableBase のカラム構成が正確か確認
- [ ] DAG 可視化の表示条件が正しいか確認
- [ ] ステージ状態分類のロジックが正確に記載されているか確認
