---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-AllStagesPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全項目に根拠あり。StageTableBase のカラム構成の正確性を確認することが望ましい。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` 行30（クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` 行34-77（render メソッド）
- E-03: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` 行36-40（プール情報取得）
- E-04: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` 行43-44（ステータス定義）
- E-05: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` 行79-103（summaryAndTableForStatus）
- E-06: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` 行84-88（Failed のみ reverse）
- E-07: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` 行59-72（Fair Scheduler 判定）
- E-08: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` 行117-123（完了ステージ表示文字列）
- E-09: `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` 行30-70（StagesTab 定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AllStagesPage は WebUIPage("") を継承する | E-01 | ○ |
| C-02 | 5つのステータス（ACTIVE/PENDING/COMPLETE/SKIPPED/FAILED）で分類 | E-04 | ○ |
| C-03 | store.stageList(null) で全ステージを取得 | E-02（行46） | ○ |
| C-04 | Fair Scheduler 使用時にプールテーブルを表示 | E-07 | ○ |
| C-05 | プール情報は Live UI でのみ利用可能 | E-03（sc.map(_.getAllPools)） | ○ |
| C-06 | Failed Stages は逆順で表示される | E-06 | ○ |
| C-07 | 空のステータスはテーブルとサマリーが非表示 | E-05（行90-91） | ○ |
| C-08 | Active ステージのキル機能は killEnabled で制御 | E-05（行93） | ○ |
| C-09 | 完了ステージ数制限メッセージは appSummary と比較して生成 | E-08 | ○ |
| C-10 | summaryAndTableForStatus で各ステータスのテーブル生成 | E-05 | ○ |
| C-11 | StagesTab がページをアタッチする | E-09（行39） | ○ |
| C-12 | isFairScheduler は SCHEDULER_MODE の設定値で判定 | E-09（行45-51） | ○ |
| C-13 | StageTableBase でステージテーブルを描画 | E-05（行96-98） | ○ |
| C-14 | PoolTable でプール一覧を描画 | E-02（行41, 68） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての主張に根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが比較的シンプルで全体を正確に把握できている

## 6) レビュアーチェックリスト（最小）
- [ ] StageTableBase のカラム構成が正確か確認（共通コンポーネント参照）
- [ ] PoolTable の表示項目が正確か確認
