---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：15-StagePage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **stagepage.js の動的テーブル描画**：JavaScript ファイルの詳細は未読のため、REST API経由の詳細仕様は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行36（クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行83-248（render メソッド）
- E-03: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行39-67（タイムライン設定）
- E-04: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行109-117（stageAttempt取得）
- E-05: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行121-123（totalTasks算出）
- E-06: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行141-211（サマリーHTML）
- E-07: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行250-455（makeTimeline）
- E-08: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行269-389（タスク時間配分計算）
- E-09: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行459-559（ApiHelper）
- E-10: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行69-81（getLocalitySummaryString）
- E-11: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` 行331-333（SPARK-8705対応）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StagePage は WebUIPage("stage") を継承 | E-01 | ○ |
| C-02 | id と attempt パラメータが必須 | E-02（行84-88） | ○ |
| C-03 | stageAttempt でステージデータとジョブIDを取得 | E-04 | ○ |
| C-04 | totalTasks が 0 の場合は "No tasks" メッセージ | E-05 | ○ |
| C-05 | ローカリティ分布は localitySummary で取得 | E-06（行119）, E-10 | ○ |
| C-06 | I/O 統計は hasInput/hasOutput 等で条件表示 | E-06（行164-199） | ○ |
| C-07 | 関連ジョブIDはリンク付きで表示 | E-06（行200-209） | ○ |
| C-08 | タイムラインは7種類の色分けで時間配分を表示 | E-03（行41-63）, E-08 | ○ |
| C-09 | totalExecutionTime が 0 の場合は空SVGバー | E-11 | ○ |
| C-10 | COLUMN_TO_INDEX でソートカラムとインデックスをマッピング | E-09（行488-516） | ○ |
| C-11 | Executor Computing Time = executorRunTime - shuffleRead - shuffleWrite | E-08（行307） | ○ |
| C-12 | Scheduler Delay は AppStatusUtils.schedulerDelay で計算 | E-08（行297） | ○ |
| C-13 | タイムラインタスク数は MAX_TIMELINE_TASKS で制限 | E-03（行67）, E-07（行269） | ○ |
| C-14 | ページネーションは eventTimelinePageNumber と eventTimelinePageSize で制御 | E-02（行94-98） | ○ |
| C-15 | DAG 可視化は operationGraphForStage で生成 | E-02（行213） | ○ |
| C-16 | stagepage.js でタスクテーブルを動的描画 | E-02（行240-243） | ○ |
| C-17 | SPARK-26109: Duration は executorRunTime を使用 | E-09（行498-499） | ○ |
| C-18 | stagepage.js の REST API 経由の詳細仕様 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- stagepage.js の内部実装（REST API呼び出し、DataTables設定等）は未読
  - 候補：stagepage.js のソースコード / OnePageApiServlet の実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイドのレンダリングロジックは正確に把握できている
- 1: 中リスク - クライアントサイド（stagepage.js）の動的テーブル描画の詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] stagepage.js のタスクテーブル描画ロジックを確認
- [ ] 時間配分計算の7カテゴリの合計が100%になることを確認
- [ ] ローカリティレベルの表示名マッピングが正確か確認
