---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：16-PoolPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **PoolTable のカラム構成**：PoolTable.scala を直接読んでいないため、テーブルカラムの正確性は要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` 行28（クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` 行30-67（render メソッド）
- E-03: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` 行31-35（パラメータ取得）
- E-04: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` 行38-40（getPoolForName）
- E-05: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` 行42-43（store.pool）
- E-06: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` 行44（lastStageAttempt）
- E-07: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` 行45-47（StageTableBase 生成）
- E-08: `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` 行41（PoolPage アタッチ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PoolPage は WebUIPage("pool") を継承 | E-01 | ○ |
| C-02 | poolname パラメータが必須 | E-03 | ○ |
| C-03 | UIUtils.decodeURLParameter でパラメータデコード | E-03（行32） | ○ |
| C-04 | sc.getPoolForName でプール取得、存在しない場合は例外 | E-04 | ○ |
| C-05 | store.pool が存在しない場合はデフォルト PoolData | E-05 | ○ |
| C-06 | uiPool.stageIds からアクティブステージを取得 | E-06 | ○ |
| C-07 | StageTableBase でアクティブステージテーブル生成 | E-07 | ○ |
| C-08 | サブパスは "stages/pool" | E-07（行47） | ○ |
| C-09 | プール情報は Live UI でのみ利用可能 | E-04（sc.flatMap） | ○ |
| C-10 | StagesTab で PoolPage がアタッチされる | E-08 | ○ |
| C-11 | killEnabled で ステージキルが制御される | E-07（行47） | ○ |
| C-12 | PoolTable のカラムは Pool Name, Minimum Share, Pool Weight, Active Stages, Running Tasks, SchedulingMode | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- PoolTable.scala のソースコードを直接読んでいないため、テーブルカラムの正確な構成は推定
  - 候補：PoolTable.scala を直接参照して確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - PoolPage.scala は69行と小さく、全体を正確に把握できている
- 1: 中リスク - PoolTable のカラム構成は推定

## 6) レビュアーチェックリスト（最小）
- [ ] PoolTable のカラム構成が正確か確認
- [ ] History Server でのプール情報の利用可否を確認
