---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：17-StoragePage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. 全項目に根拠あり。ソースコードが比較的シンプルで正確に把握できている。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行32（クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行34-38（render メソッド）
- E-03: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行40-65（rddTable）
- E-04: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行68-75（rddHeader）
- E-05: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行88-106（rddRow）
- E-06: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行108-121（receiverBlockTables）
- E-07: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行123-134（executorMetricsTable）
- E-08: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行136-141（executorMetricsTableHeader）
- E-09: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行163-177（streamBlockTable）
- E-10: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行179-184（streamBlockTableHeader）
- E-11: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行222-233（streamBlockStorageLevelDescriptionAndSize）
- E-12: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` 行237-249（ExecutorStreamSummary）
- E-13: `core/src/main/scala/org/apache/spark/ui/storage/StorageTab.scala` 行24-29（StorageTab）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StoragePage は WebUIPage("") を継承 | E-01 | ○ |
| C-02 | store.rddList() で RDD 一覧を取得 | E-02 | ○ |
| C-03 | store.streamBlocksList() でブロック一覧を取得 | E-02 | ○ |
| C-04 | RDDが永続化されていない場合、RDDテーブルは非表示 | E-03（行43-45） | ○ |
| C-05 | RDDテーブルのカラムは ID, RDD Name, Storage Level, Cached Partitions, Fraction Cached, Size in Memory, Size on Disk | E-04 | ○ |
| C-06 | Fraction Cached は numCachedPartitions * 100.0 / numPartitions で計算 | E-05（行101） | ○ |
| C-07 | ストリームブロックが存在しない場合、セクションは非表示 | E-06（行109-110） | ○ |
| C-08 | Executor別集計テーブルのカラムは Executor ID, Address, Total Size in Memory, Total Size on Disk, Stream Blocks | E-08 | ○ |
| C-09 | ブロック一覧テーブルのカラムは Block ID, Replication Level, Location, Storage Level, Size | E-10 | ○ |
| C-10 | ストレージレベル判定は useDisk/useMemory/deserialized フラグで行う | E-11 | ○ |
| C-11 | ExecutorStreamSummary でExecutor別集計を行う | E-12 | ○ |
| C-12 | ブロック一覧テーブルはソート不可 | E-09（行174） | ○ |
| C-13 | RDD名はRDD詳細ページへのリンク付き | E-05（行93-96） | ○ |
| C-14 | StorageTab で StoragePage と RDDPage がアタッチ | E-13 | ○ |
| C-15 | tooltips が RDD テーブルヘッダーに定義されている | E-03（行61）, E-01周辺 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての主張に根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが明確で全体を正確に把握できている

## 6) レビュアーチェックリスト（最小）
- [ ] ToolTips.scala の内容が正確に反映されているか確認
- [ ] RDDStorageInfo と StreamBlockData のデータ構造定義を確認
