---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-RDDPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. 全項目に根拠あり。ソースコードから正確に読み取れている。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行33（クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行35-130（render メソッド）
- E-03: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行42-48（RDD取得とエラーハンドリング）
- E-04: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行51-52（workerTable）
- E-05: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行133-137（workerHeader）
- E-06: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行140-153（workerRow）
- E-07: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行54-65（BlockPagedTable）
- E-08: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行163-208（BlockDataSource）
- E-09: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行178-188（blockRow）
- E-10: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行193-207（ordering）
- E-11: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行249-260（headers）
- E-12: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` 行67-81（スクロールJavaScript）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | RDDPage は WebUIPage("rdd") を継承 | E-01 | ○ |
| C-02 | id パラメータが必須 | E-02（行36-37） | ○ |
| C-03 | store.rdd(rddId) で RDD 情報取得 | E-03 | ○ |
| C-04 | NoSuchElementException で "RDD Not Found" 表示 | E-03（行45-47） | ○ |
| C-05 | Worker テーブルのカラムは Host, On Heap Memory Usage, Off Heap Memory Usage, Disk Usage | E-05 | ○ |
| C-06 | On Heap/Off Heap メモリは Optional で 0 フォールバック | E-06（行144-149） | ○ |
| C-07 | BlockPagedTable でページネーション付きテーブル生成 | E-07 | ○ |
| C-08 | ブロックテーブルのカラムは Block Name, Storage Level, Size in Memory, Size on Disk, Executors | E-11（行250-255） | ○ |
| C-09 | 全カラムがソート可能 | E-11（行250-255、全てtrue） | ○ |
| C-10 | Executors カラムは ID をアドレスに変換 | E-09（行184-187） | ○ |
| C-11 | デフォルトソートは Block Name | E-07（行217） | ○ |
| C-12 | ブロックソート後にテーブル位置に自動スクロール | E-12 | ○ |
| C-13 | store.executorList(true) で Executor マッピング構築 | E-07（行60） | ○ |
| C-14 | テーブル描画エラーはcatch句で処理される | E-07（行62-64） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての主張に根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから正確に読み取れている

## 6) レビュアーチェックリスト（最小）
- [ ] RDDStorageInfo の dataDistribution と partitions のデータ構造を確認
- [ ] ページネーションパラメータの動作を確認
