---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-EnvironmentPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全項目に根拠あり。ソースコードが明確で正確に読み取れている。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行31-34（クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行36-176（render メソッド）
- E-03: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行37-41（environmentInfo取得、JVM情報）
- E-04: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行43-56（リソース文字列生成関数）
- E-05: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行64-69（resourceProfileInfo取得）
- E-06: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行77-78（Spark Properties、リダクト処理）
- E-07: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行81-83（Hadoop Properties）
- E-08: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行84-86（System Properties）
- E-09: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行87-89（Metrics Properties）
- E-10: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行90-92（Classpath Entries）
- E-11: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行95-102（arrow-open: Runtime Information）
- E-12: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行128-137（arrow-closed: Hadoop Properties）
- E-13: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行184-185（jvmRowDataPre: pre タグ使用）
- E-14: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` 行191-195（EnvironmentTab）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EnvironmentPage は WebUIPage("") を継承 | E-01 | ○ |
| C-02 | store.environmentInfo() で環境情報取得 | E-03 | ○ |
| C-03 | JVM情報は javaVersion, javaHome, scalaVersion | E-03（行38-41） | ○ |
| C-04 | store.resourceProfileInfo() でリソースプロファイル取得 | E-05 | ○ |
| C-05 | Spark Properties は Utils.redact で リダクト処理 | E-06 | ○ |
| C-06 | Hadoop Properties は Utils.redact でリダクト処理 | E-07 | ○ |
| C-07 | System Properties は Utils.redact でリダクト処理 | E-08 | ○ |
| C-08 | Metrics Properties は Utils.redact でリダクト処理 | E-09 | ○ |
| C-09 | Classpath Entries はリダクト対象外 | E-10（Utils.redact なし） | ○ |
| C-10 | Runtime Information は初期展開状態（arrow-open） | E-11 | ○ |
| C-11 | Hadoop Properties は初期折りたたみ状態（arrow-closed） | E-12 | ○ |
| C-12 | Resource Profile Contents は pre タグで表示 | E-13 | ○ |
| C-13 | hadoopProperties は Option で null フォールバック | E-07（行82） | ○ |
| C-14 | metricsProperties は Option で null フォールバック | E-09（行88） | ○ |
| C-15 | テーブルは fixedWidth = true | E-06, E-07, E-08, E-09, E-10 | ○ |
| C-16 | EnvironmentTab は SparkUITab を継承 | E-14 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全ての主張に根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードが明確で全体を正確に把握できている

## 6) レビュアーチェックリスト（最小）
- [ ] environmentpage.js の機能内容を確認
- [ ] Utils.redact のリダクトパターン（どのキーが対象か）を確認
