---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：2-ConsoleSink メトリクスレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **コンソール出力の詳細フォーマット**：ConsoleReporter の出力形式は Dropwizard ライブラリの内部実装に依存

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/metrics/sink/ConsoleSink.scala` 行27-63
- E-02: `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` 行20-24
- E-03: `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` 行97-106, 199-240, 252-258
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行3（No.2 の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ConsoleSink は Dropwizard ConsoleReporter を使用する | E-01（行23, 47） | ○ |
| C-02 | デフォルト出力間隔は10秒 | E-01（行29: CONSOLE_DEFAULT_PERIOD = 10） | ○ |
| C-03 | デフォルト時間単位は SECONDS | E-01（行30: CONSOLE_DEFAULT_UNIT = "SECONDS"） | ○ |
| C-04 | Duration はミリ秒に変換される | E-01（行48: convertDurationsTo(TimeUnit.MILLISECONDS)） | ○ |
| C-05 | Rate は秒単位に変換される | E-01（行49: convertRatesTo(TimeUnit.SECONDS)） | ○ |
| C-06 | build() に引数なし（System.out がデフォルト出力先） | E-01（行50: .build()） | ○ |
| C-07 | CsvSink と異なり directory 設定は不要 | E-01（設定キーに directory が存在しない） | ○ |
| C-08 | Sink トレイトの start/stop/report を実装 | E-01（行52-62）, E-02 | ○ |
| C-09 | MetricsSystem.start() が ConsoleSink を起動する | E-03（行97-106） | ○ |
| C-10 | checkMinimalPollingPeriod で最小間隔を検証 | E-01（行45）, E-03（行252-258） | ○ |
| C-11 | Properties から period と unit を読み込む | E-01（行35-43） | ○ |
| C-12 | start() で ConsoleReporter.start() を呼び出す | E-01（行52-54） | ○ |
| C-13 | stop() で ConsoleReporter.stop() を呼び出す | E-01（行56-58） | ○ |
| C-14 | report() で ConsoleReporter.report() を呼び出す | E-01（行60-62） | ○ |
| C-15 | コンソール出力フォーマット（Gauges/Counters/Histograms/Meters/Timers のセクション分け） | **外部ライブラリ依存** | △ |

## 4) 不足情報（Unknown / Missing）
- ConsoleReporter の出力フォーマットの詳細は Dropwizard Metrics ライブラリの内部実装に依存するため、正確なフォーマットの保証にはライブラリのソースコード確認が必要
  - 候補：Dropwizard Metrics 公式ドキュメント / ConsoleReporter.java ソースコード / 実機出力サンプル

## 5) リスクフラグ（レビュー観点）
- 0: 全体的にシンプルな実装であり、低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ConsoleSink.scala のデフォルト値（period=10, unit=SECONDS）が正確か確認
- [ ] ConsoleReporter の実際の出力フォーマットを Dropwizard ドキュメントで検証
- [ ] MetricsSystem からの起動フローの記述が正確か確認
