---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：20-ExecutorsTab

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **executorspage.js のテーブルカラム構成**：JavaScript ファイルを直接読んでいないため推定
  2. **REST API エンドポイントパス**：executorspage.js の実際の API 呼び出しパスは未確認
  3. **DataTables の使用方法**：executorspage.js 内の DataTables 設定は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行27（ExecutorsTab クラス定義）
- E-02: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行31-44（init メソッド）
- E-03: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行32-33（threadDumpEnabled 判定）
- E-04: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行34-35（heapHistogramEnabled 判定）
- E-05: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行37（ExecutorsPage アタッチ）
- E-06: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行38-39（ExecutorThreadDumpPage アタッチ）
- E-07: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行41-43（ExecutorHeapHistogramPage アタッチ）
- E-08: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行48-52（ExecutorsPage クラス定義）
- E-09: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行54-77（render メソッド）
- E-10: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行67-74（HTML構成、div#active-executors）
- E-11: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` 行76（useDataTables = true）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExecutorsTab は SparkUITab を継承 | E-01 | ○ |
| C-02 | init() でサブページをアタッチ | E-02 | ○ |
| C-03 | threadDumpEnabled は sc.isDefined && UI_THREAD_DUMPS_ENABLED で判定 | E-03 | ○ |
| C-04 | heapHistogramEnabled は sc.isDefined && UI_HEAP_HISTOGRAM_ENABLED で判定 | E-04 | ○ |
| C-05 | ExecutorsPage は常にアタッチされる | E-05 | ○ |
| C-06 | ExecutorThreadDumpPage は threadDumpEnabled 時のみアタッチ | E-06 | ○ |
| C-07 | ExecutorHeapHistogramPage は heapHistogramEnabled 時のみアタッチ | E-07 | ○ |
| C-08 | ExecutorsPage は WebUIPage("") を継承 | E-08 | ○ |
| C-09 | render は最小限HTML + JavaScript で構成 | E-10 | ○ |
| C-10 | div#active-executors が executorspage.js の描画先 | E-10 | ○ |
| C-11 | useDataTables = true で DataTables 有効化 | E-11 | ○ |
| C-12 | setThreadDumpEnabled / setHeapHistogramEnabled を JS で呼び出し | E-09（行64-65） | ○ |
| C-13 | テーブルカラムは Executor ID, Address, RDD Blocks, Storage Memory, Disk Used, Cores, Active Tasks, Failed Tasks, Complete Tasks, Total Tasks, Task Time, GC Time, Input, Shuffle Read, Shuffle Write | **根拠なし** | △ |
| C-14 | REST API エンドポイントは /api/v1/applications/{appId}/allexecutors | **根拠なし** | △ |
| C-15 | DataTables ライブラリでクライアントサイドソート・ページネーション | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- executorspage.js のソースコードを直接読んでいないため、テーブルカラム構成・REST APIパス・DataTables設定は推定
  - 候補：executorspage.js / REST API ドキュメント / DataTables 設定
- ExecutorSummary の全フィールドが実際にテーブルに表示されるかは未確認
  - 候補：executorspage.js の DataTables column 定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイドのコードは正確に把握できている
- 2: 高リスク - クライアントサイドの描画ロジック（executorspage.js）が未読のため、テーブル構成は推定に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] executorspage.js のテーブルカラム構成を確認
- [ ] REST API エンドポイントのパスとレスポンス形式を確認
- [ ] DataTables のソート・ページネーション設定を確認
- [ ] Active/Dead Executors の分類ロジックを確認
