---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：22-AllExecutionsPage（SQL）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **想定データ件数**：具体的なベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` 行35-592
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` 行24-44
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` SQLExecutionUIData 定義
- E-04: `core/src/main/scala/org/apache/spark/internal/config/UI.scala` UI_SQL_GROUP_SUB_EXECUTION_ENABLED 定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AllExecutionsPage は SQL/DataFrame 実行一覧を表示する | E-01 (行35, 行194 "SQL / DataFrame") | ○ |
| C-02 | 実行を Running/Completed/Failed に3分類する | E-01 (行42-53) | ○ |
| C-03 | sqlStore.executionsList() で全件取得する | E-01 (行48) | ○ |
| C-04 | Sub Execution のグルーピング機能がある | E-01 (行56-72), E-04 | ○ |
| C-05 | テーブル列に ID, Query ID, Description, Submitted, Duration がある | E-01 (行299-305) | ○ |
| C-06 | Running/Succeeded/Failed Job IDs の列がある | E-01 (行306-317) | ○ |
| C-07 | Error Message 列は Failed テーブルのみ表示 | E-01 (行319-323, showErrorMessage フラグ) | ○ |
| C-08 | Sub Execution IDs 列がある | E-01 (行325-330) | ○ |
| C-09 | Duration は completionTime - submissionTime で計算 | E-01 (行537-538) | ○ |
| C-10 | 実行中クエリの Duration は現在時刻を使用 | E-01 (行537 `getOrElse(currentTime)`) | ○ |
| C-11 | Running Jobs は RUNNING ステータスでフィルタ | E-01 (行540-543) | ○ |
| C-12 | PagedTable によるページング機能がある | E-01 (行254 `extends PagedTable`) | ○ |
| C-13 | デフォルトソートカラムは ID | E-01 (行256 `getTableParameters(request, executionTag, "ID")`) | ○ |
| C-14 | unknownColumn 時に QueryExecutionErrors.unknownColumnError を投げる | E-01 (行584) | ○ |
| C-15 | テーブル描画エラー時に alert-error 表示 | E-01 (行229-236) | ○ |
| C-16 | SQLTab は prefix "SQL" で登録される | E-02 (行25 `SparkUITab(sparkUI, "SQL")`) | ○ |
| C-17 | AllExecutionsPage と ExecutionPage の2ページが SQLTab に登録される | E-02 (行33-34) | ○ |
| C-18 | Query ID が null の場合 "N/A" と表示する | E-01 (行377 `getOrElse("N/A")`) | ○ |
| C-19 | Description に +details 展開機能がある | E-01 (行476-496) | ○ |
| C-20 | 想定データ件数は数百から数千 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20（想定データ件数）は設計書作成者の推定であり、実環境のデータ量計測に基づくものではない
  - 候補：運用実績データ / SQLAppStatusStore の保持上限設定 / spark.sql.ui.retainedExecutions 設定値

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の表示ページであり、データ変更を伴わない
- 0: 低リスク - Sub Execution グルーピングは設定で無効化可能

## 6) レビュアーチェックリスト（最小）
- [ ] Sub Execution グルーピングの表示が運用要件と合致しているか確認
- [ ] ページサイズのデフォルト値が実運用で適切か確認
- [ ] エラーメッセージの表示制限（長さ等）が適切か確認
