---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-ExecutionPage（SQL）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **DAG ノード数の想定値**：ベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` 行32-269
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` 行34
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExecutionPage は個別 SQL 実行の詳細を表示する | E-01 (行32, 行142 "Details for Query") | ○ |
| C-02 | id パラメータは必須である | E-01 (行42-43 require文) | ○ |
| C-03 | sqlStore.execution() で実行データを取得する | E-01 (行46) | ○ |
| C-04 | Duration を completionTime - submissionTime で計算する | E-01 (行48-49) | ○ |
| C-05 | RUNNING/SUCCEEDED/FAILED のジョブリンクを生成する | E-01 (行110-112) | ○ |
| C-06 | Plan Visualization は D3.js + dagre-d3 で描画する | E-01 (行148-154) | ○ |
| C-07 | DOT ファイルは graph.makeDotFile(metrics) で生成する | E-01 (行179) | ○ |
| C-08 | Physical Plan Description は折り畳み式で表示する | E-01 (行189-201 style="display: none") | ○ |
| C-09 | SQL Properties は modifiedConfigs から取得する | E-01 (行128, 203-225) | ○ |
| C-10 | Pandas on Spark の設定は pandas_on_Spark. プレフィックスで区別 | E-01 (行34 `pandasOnSparkConfPrefix`) | ○ |
| C-11 | Pandas on Spark の値は Python repr() 形式に変換される | E-01 (行236-241) | ○ |
| C-12 | データなし時に "No information to display" を表示する | E-01 (行138) | ○ |
| C-13 | Download ボタンが SVG/DOT/TXT 形式を選択可能 | E-01 (行116-119) | ○ |
| C-14 | Parent Execution リンクが表示される | E-01 (行85-93) | ○ |
| C-15 | Sub Executions リンクが表示される | E-01 (行95-109) | ○ |
| C-16 | groupSubExecutionEnabled 設定に依存する | E-01 (行37, 95) | ○ |
| C-17 | stageId と taskId チェックボックスがある | E-01 (行173-175) | ○ |
| C-18 | DAG ノード数は数十から数百と想定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18（DAG ノード数の想定）は設計書作成者の推定であり、実環境の計測に基づかない
  - 候補：実運用クエリのプラングラフ分析 / SparkPlanGraph のノード数統計

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の表示ページ
- 1: 中リスク - DOT ファイルダウンロード機能により、クエリ構造情報が外部流出する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] Plan Visualization の描画が大規模クエリでも正常に動作するか確認
- [ ] Modified Configs に機密情報が含まれないことを確認
- [ ] DOT ファイルダウンロードのアクセス制御が適切か確認
