---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：24-StreamingQueryPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目の根拠が確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryPage.scala` 行33-261
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryTab.scala` 行23-42
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/UIUtils.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingQueryPage は Structured Streaming クエリ一覧を表示する | E-01 (行33-34, 行38 "Streaming Query") | ○ |
| C-02 | Active / Completed に partition で分類する | E-01 (行42-43) | ○ |
| C-03 | デフォルトソートは Start Time | E-01 (行122 `getTableParameters(request, tableTag, "Start Time")`) | ○ |
| C-04 | テーブル列に Name, Status, ID, Run ID, Start Time, Duration 等がある | E-01 (行151-167) | ○ |
| C-05 | Error 列は inactive (Completed) テーブルのみ表示 | E-01 (行162-166 `if (!isActive)`) | ○ |
| C-06 | Run ID から統計ページへのリンクが生成される | E-01 (行176-178) | ○ |
| C-07 | Duration (Active) は currentTimeMillis - startTimestamp | E-01 (行224-225) | ○ |
| C-08 | Duration (Completed) は lastProgress.timestamp - startTimestamp | E-01 (行227-230) | ○ |
| C-09 | Avg Input /sec は recentProgress の平均 | E-01 (行233-234) | ○ |
| C-10 | Avg Process /sec は recentProgress の平均 | E-01 (行236-237) | ○ |
| C-11 | Progress なしの場合 withNoProgress で "NaN" 表示 | E-01 (行195-197, E-03) | ○ |
| C-12 | PagedTable によるページング機能がある | E-01 (行120 `extends PagedTable`) | ○ |
| C-13 | StreamingQueryTab の prefix は "StreamingQuery" | E-02 (行25) | ○ |
| C-14 | StreamingQueryTab の表示名は "Structured Streaming" | E-02 (行27) | ○ |
| C-15 | テーブル描画エラー時に alert-error 表示 | E-01 (行102-108) | ○ |
| C-16 | ソートカラムは Name, Status, ID, Run ID, Start Time, Duration, Avg Input/sec, Avg Process/sec, Latest Batch | E-01 (行243-253) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張にソースコード根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の表示ページ

## 6) レビュアーチェックリスト（最小）
- [ ] withNoProgress のフォールバック値が適切か確認
- [ ] 平均レートの計算で NaN/Infinity が適切にハンドリングされているか確認
