---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：25-StreamingQueryStatisticsPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間**：ベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` 行37-565
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryTab.scala` 行32
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/internal/StaticSQLConf.scala` ENABLED_STREAMING_UI_CUSTOM_METRIC_LIST

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingQueryStatisticsPage は詳細統計を表示する | E-01 (行37-38, 行73 "Streaming Query Statistics") | ○ |
| C-02 | id パラメータ (runId) は必須 | E-01 (行60-61) | ○ |
| C-03 | Input Rate のタイムラインとヒストグラムを表示 | E-01 (行434-444, 行507-511) | ○ |
| C-04 | Process Rate のグラフを表示 | E-01 (行446-456, 行513-520) | ○ |
| C-05 | Input Rows のグラフを表示 | E-01 (行458-468, 行522-529) | ○ |
| C-06 | Batch Duration のグラフを表示 | E-01 (行470-480, 行531-538) | ○ |
| C-07 | Operation Duration はエリアスタックグラフで表示 | E-01 (行482-491, 行540-546) | ○ |
| C-08 | triggerExecution は Operation Duration から除外 | E-01 (行428 `durationMs.remove("triggerExecution")`) | ○ |
| C-09 | Watermark Gap はステートフルクエリで表示 | E-01 (行146-196) | ○ |
| C-10 | Watermark Gap は秒単位で計算 | E-01 (行159 `(batchTimestamp - watermarkValue) / 1000.0`) | ○ |
| C-11 | ステートオペレータメトリクスは合計値で集約 | E-01 (行206-207 `.map(_.numRowsTotal).sum`) | ○ |
| C-12 | Total/Updated/Removed State Rows のグラフを表示 | E-01 (行287-315) | ○ |
| C-13 | State Memory Used のグラフを表示 | E-01 (行316-324) | ○ |
| C-14 | Dropped by Watermark のグラフを表示 | E-01 (行325-333) | ○ |
| C-15 | カスタムメトリクスは設定で有効化 | E-01 (行46-48), E-03 | ○ |
| C-16 | lastProgress が null の場合 "No visualization information available." | E-01 (行553-556) | ○ |
| C-17 | D3.js と structured-streaming-page.js を使用 | E-01 (行52-56) | ○ |
| C-18 | 基本情報に Name, Id, RunId を表示 | E-01 (行114-143) | ○ |
| C-19 | numBatches は lastProgress.batchId + 1 で計算 | E-01 (行128) | ○ |
| C-20 | 目標出力時間は 2 秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20（目標出力時間）は設計書作成者の推定であり、パフォーマンステスト結果に基づくものではない
  - 候補：パフォーマンスベンチマーク / recentProgress サイズの上限確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の表示ページ
- 1: 中リスク - 大量の recentProgress データでグラフ描画が遅延する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] recentProgress の保持件数上限が適切か確認
- [ ] カスタムメトリクス設定の運用ガイドラインが整備されているか確認
- [ ] Watermark Gap の計算ロジックが正しいか確認
