---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：26-StreamingPage（DStream）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **DStream 非推奨ステータス**：Spark バージョン固有の情報

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` 行37-554
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` 行28-48
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/ui/UIUtils.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamingPage は DStream 統計ダッシュボードである | E-01 (行73-74, 行94 "Streaming Statistics") | ○ |
| C-02 | listener.synchronized でスレッドセーフにデータ取得 | E-01 (行90) | ○ |
| C-03 | Input Rate は records/sec で表示 | E-01 (行179-180 `numRecords * 1000.0 / batchDuration`) | ○ |
| C-04 | Scheduling Delay / Processing Time / Total Delay の Y 軸範囲が統一される | E-01 (行195-197) | ○ |
| C-05 | 時間単位は normalizeDuration で正規化される | E-01 (行200), E-03 | ○ |
| C-06 | Processing Time にバッチ間隔リファレンスラインがある | E-01 (行245 `Some(batchInterval)`) | ○ |
| C-07 | 入力ソース別展開テーブルがある | E-01 (行304-310, generateInputDStreamsTable) | ○ |
| C-08 | レシーバ情報（Active/Inactive, Location, Error）が表示される | E-01 (行394-411) | ○ |
| C-09 | Running / Waiting / Completed バッチ一覧がある | E-01 (行471-537) | ○ |
| C-10 | バッチは batchTime.milliseconds の降順でソート | E-01 (行472-475) | ○ |
| C-11 | 基本情報にバッチ間隔、稼働時間、完了バッチ数、受信レコード数が表示される | E-01 (行124-141) | ○ |
| C-12 | StreamingTab の prefix は "streaming" | E-02 (行29) | ○ |
| C-13 | MillisecondsStatUIData で avg/max を計算 | E-01 (行51-56) | ○ |
| C-14 | RecordRateUIData で avg を計算 | E-01 (行66-68) | ○ |
| C-15 | テーブル描画エラー時に alert-error 表示 | E-01 (行461-468) | ○ |
| C-16 | D3.js と streaming-page.js を使用 | E-01 (行101-105) | ○ |
| C-17 | generateTimeMap / generateTimeTipStrings でタイムゾーン統一 | E-01 (行152-169) | ○ |
| C-18 | DStream API は非推奨である | **根拠なし**（ソースコード内に deprecated 記述確認未了） | △ |

## 4) 不足情報（Unknown / Missing）
- C-18（DStream 非推奨ステータス）は Spark リリースノートや公式ドキュメントに記載されているが、対象ソースコード内には明示的な deprecated アノテーションが確認できていない
  - 候補：Spark 3.4 リリースノート / StreamingContext のクラス Scaladoc

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - DStream API は非推奨であり、将来のバージョンで削除される可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] DStream の非推奨ステータスと移行計画を確認
- [ ] retainedBatches のサイズ上限設定を確認
- [ ] レシーバエラー情報の表示制限を確認
