---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-BatchPage（DStream）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 全項目の根拠が確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/ui/BatchPage.scala` 行30-424
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` 行37

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BatchPage はバッチ詳細を表示する | E-01 (行32, 行378 "Details of batch at") | ○ |
| C-02 | id パラメータ（batchTime）が必須 | E-01 (行322-325) | ○ |
| C-03 | バッチが存在しない場合に例外を投げる | E-01 (行330-331) | ○ |
| C-04 | Batch Duration / Scheduling delay / Processing time / Total delay を表示 | E-01 (行333-337, 342-365) | ○ |
| C-05 | Input data size をレコード数で表示 | E-01 (行352) | ○ |
| C-06 | Input Metadata テーブルを表示 | E-01 (行366-370, 381-393) | ○ |
| C-07 | Output Op Id, Description, Duration, Status の列がある | E-01 (行36-49) | ○ |
| C-08 | Job Id, Job Duration, Stages, Tasks, Error の列がある | E-01 (行43-49) | ○ |
| C-09 | rowspan で同一 Output Op の複数ジョブをグループ化 | E-01 (行120-126) | ○ |
| C-10 | generateNormalJobRow で正常ジョブの行を生成 | E-01 (行94-160) | ○ |
| C-11 | generateDroppedJobRow で破棄ジョブの行を生成 | E-01 (行166-201) | ○ |
| C-12 | store.job(jobId) で Spark ジョブ詳細を取得 | E-01 (行257-263) | ○ |
| C-13 | store.lastStageAttempt(stageId) でステージ詳細を取得 | E-01 (行265-271) | ○ |
| C-14 | makeProgressBar でタスク進捗バーを描画 | E-01 (行149-155) | ○ |
| C-15 | Output Op の description に +details 展開がある | E-01 (行243-255) | ○ |
| C-16 | metadataDescription はタブを4スペースに変換 | E-01 (行406-407) | ○ |
| C-17 | listener.synchronized でスレッドセーフ | E-01 (行321) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張にソースコード根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の表示ページ

## 6) レビュアーチェックリスト（最小）
- [ ] ジョブが破棄された場合の表示が運用上十分な情報を提供するか確認
- [ ] failureReason の表示が適切にエスケープされているか確認
