---
generated_at: 2026-02-04 10:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-ThriftServerPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目の根拠が確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerPage.scala` 行34-442
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerTab.scala` 行29-53
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ToolTips.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ThriftServerPage は JDBC/ODBC Server ダッシュボードである | E-01 (行34, 行53 "JDBC/ODBC Server") | ○ |
| C-02 | store.synchronized でスレッドセーフにデータ取得 | E-01 (行40) | ○ |
| C-03 | 基本統計に Started at と Time since start を表示 | E-01 (行57-67) | ○ |
| C-04 | オンラインセッション数を表示 | E-01 (行44) | ○ |
| C-05 | 実行中 SQL 数を表示 | E-01 (行47) | ○ |
| C-06 | Session Statistics テーブルがある | E-01 (行117-162) | ○ |
| C-07 | SQL Statistics テーブルがある | E-01 (行70-114) | ○ |
| C-08 | デフォルトソートは Start Time | E-01 (行174 `getTableParameters(..., "Start Time")`) | ○ |
| C-09 | Session テーブルに User, IP, Session ID, Start/Finish Time, Duration, Total Execute がある | E-01 (行321-329) | ○ |
| C-10 | SQL テーブルに User, JobID, GroupID, Start/Finish/Close Time, Execution Time, Duration, Statement, State, Detail がある | E-01 (行207-218) | ○ |
| C-11 | Session ID からセッション詳細へリンク | E-01 (行338-339) | ○ |
| C-12 | Finish Time と Close Time のツールチップがある | E-01 (行212-213), E-03 | ○ |
| C-13 | Detail 列には detail が空の場合 executePlan を表示 | E-01 (行376-377) | ○ |
| C-14 | データなし時に "No statistics have been generated yet." 表示 | E-01 (行111-112) | ○ |
| C-15 | ThriftServerTab の prefix は "sqlserver" | E-02 (行31) | ○ |
| C-16 | ThriftServerTab の表示名は "JDBC/ODBC Server" | E-02 (行32) | ○ |
| C-17 | テーブル描画エラー時に alert-error 表示 | E-01 (行90-96) | ○ |
| C-18 | Duration は totalTime(closeTimestamp) で計算 | E-01 (行374) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張にソースコード根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - SQL Statement の表示にはクエリ文全体が含まれるため、機密情報漏洩に注意

## 6) レビュアーチェックリスト（最小）
- [ ] SQL Statement の表示制限（文字数等）が適切か確認
- [ ] IP アドレスの表示がセキュリティポリシーに適合するか確認
- [ ] Session ID リンクから正しいセッション詳細ページに遷移するか確認
