---
generated_at: 2026-02-04 11:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-SparkConnectServerPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全項目の根拠が確認済み

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerPage.scala` 行34-526
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerTab.scala` 行27-59
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerSessionPage.scala` 行30-131
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/ToolTips.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkConnectServerPage は Spark Connect ダッシュボードである | E-01 (行34-36, 行56 "Spark Connect") | ○ |
| C-02 | store.synchronized でスレッドセーフにデータ取得 | E-01 (行43) | ○ |
| C-03 | 基本統計に Started at と Time since start を表示 | E-01 (行60-70) | ○ |
| C-04 | オンラインセッション数とリクエスト数を表示 | E-01 (行47-51) | ○ |
| C-05 | Session Statistics テーブルがある | E-01 (行122-167) | ○ |
| C-06 | Request Statistics テーブルがある | E-01 (行73-119) | ○ |
| C-07 | デフォルトソートは Start Time | E-01 (行181 `getTableParameters(..., "Start Time")`) | ○ |
| C-08 | Session テーブルに User, Session ID, Start/Finish Time, Duration, Total Execute がある | E-01 (行385-392) | ○ |
| C-09 | Request テーブルに User, Job ID, SQL Query ID, Session ID 等 15 列がある | E-01 (行213-246) | ○ |
| C-10 | showSessionLink パラメータで Session ID 列の表示を制御 | E-01 (行177, 213-247, 293-298) | ○ |
| C-11 | State は isExecutionActive なら "RUNNING" にオーバーライド | E-01 (行321) | ○ |
| C-12 | Operation ID 列がある | E-01 (行323-325) | ○ |
| C-13 | Job Tag 列がある | E-01 (行326-328) | ○ |
| C-14 | Spark Session Tags 列がある（カンマ区切り） | E-01 (行329-331) | ○ |
| C-15 | SQL Query ID リンクが SQL 実行ページへ遷移 | E-01 (行339-340) | ○ |
| C-16 | Session ID リンクがセッション詳細へ遷移 | E-01 (行407-410) | ○ |
| C-17 | SparkConnectServerTab の prefix は "connect" | E-02 (行30) | ○ |
| C-18 | SparkConnectServerTab の表示名は "Connect" | E-02 (行33) | ○ |
| C-19 | SparkConnectServerSessionPage が登録されている | E-02 (行44) | ○ |
| C-20 | Connect は ThriftServer と類似構造だが userId / operationId / jobTag / sparkSessionTags 等が追加 | E-01 (行213-246), No.28 の E-01 比較 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張にソースコード根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Statement にクエリ文が含まれるため、機密情報漏洩に注意
- 0: 低リスク - Spark Session Tags はマルチテナント追跡に有用だが、過剰な情報を含まないか確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] Statement の表示制限が適切か確認
- [ ] Spark Session Tags の表示がセキュリティポリシーに適合するか確認
- [ ] showSessionLink のフラグが正しく機能しているか確認
- [ ] SQL Query ID リンクが正しい SQL 実行ページに遷移するか確認
