---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 33
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：31-SparkConnectServerSessionPage

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：33 / 35、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の目標出力時間**：具体的な数値根拠なし
  2. **セキュリティ考慮事項の ACL 制御**：設定パラメータ名は Spark UI 共通仕様からの推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerSessionPage.scala` (132行)
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerTab.scala` (60行)
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerAppStatusStore.scala` (132行)
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerPage.scala` (527行)
- E-05: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerListener.scala` (453行)
- E-06: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/ToolTips.scala` (39行)
- E-07: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerHistoryServerPlugin.scala` (41行)
- E-08: `sql/connect/server/src/test/scala/org/apache/spark/sql/connect/ui/SparkConnectServerPageSuite.scala` (135行)
- E-09: `docs/code-to-docs/帳票一覧/帳票一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 帳票は Spark Connect Server の個別セッション詳細を HTML で表示する | E-01 (29行目: クラスコメント "information pertaining to a single Spark Connect session") | ○ |
| C-02 | URL パスは `/connect/session/?id={sessionId}` | E-01 (31行目: `WebUIPage("session")`), E-02 (30行目: `SparkUITab(sparkUI, "connect")`) | ○ |
| C-03 | HTTP リクエストパラメータ `id` でセッション ID を取得 | E-01 (39行目: `request.getParameter("id")`) | ○ |
| C-04 | sessionId が null または空の場合は require で例外発生 | E-01 (40行目: `require(sessionId != null && sessionId.nonEmpty, "Missing id parameter")`) | ○ |
| C-05 | store.synchronized ブロックでデータ一貫性を保証 | E-01 (42行目: `store.synchronized { ... }`) | ○ |
| C-06 | store.getSession() で KVStore から SessionInfo を取得 | E-01 (44行目), E-03 (42-48行目) | ○ |
| C-07 | セッションが見つからない場合は "No information to display" メッセージ表示 | E-01 (61行目: `.getOrElse(<div>No information to display ...)`) | ○ |
| C-08 | 基本統計情報に Session ID、Started at、Time since start を表示 | E-01 (67-80行目: `generateBasicStats()`) | ○ |
| C-09 | セッションサマリーに User、Session created at、Total run Request(s) を表示 | E-01 (48-58行目: h4 タグ内の表示) | ○ |
| C-10 | リクエスト統計テーブルは SqlStatsPagedTable で生成、showSessionLink=false | E-01 (96-103行目) | ○ |
| C-11 | リクエスト統計テーブルは ExecutionInfo を sessionId でフィルタリング | E-01 (84-85行目: `store.getExecutionList.filter(_.sessionId == sessionID)`) | ○ |
| C-12 | テーブルカラムに User, Job ID, SQL Query ID, Start Time 等14項目を表示 | E-04 (232-246行目: showSessionLink=false 時のヘッダー定義) | ○ |
| C-13 | Job ID はジョブ詳細ページへのリンク付き | E-04 (267-271行目: `jobURL`, 336-337行目) | ○ |
| C-14 | SQL Query ID は SQL 実行詳細ページへのリンク付き | E-04 (272-276行目: `sqlURL`, 339-340行目) | ○ |
| C-15 | State が STARTED/COMPILED/READY の場合 "RUNNING" と表示 | E-04 (321行目), E-03 (112-117行目: `isExecutionActive`) | ○ |
| C-16 | ExecutionState は 7 状態 (STARTED, COMPILED, READY, CANCELED, FAILED, FINISHED, CLOSED) | E-03 (128-129行目) | ○ |
| C-17 | SessionInfo のフィールド: sessionId, startTimestamp, userId, finishTimestamp, totalExecution | E-03 (76-91行目) | ○ |
| C-18 | ExecutionInfo のフィールド: jobTag, statement, sessionId, startTimestamp 等13フィールド | E-03 (93-126行目) | ○ |
| C-19 | Execution Time = totalTime(finishTimestamp) | E-04 (448行目), E-03 (119-125行目) | ○ |
| C-20 | Duration = totalTime(closeTimestamp) | E-04 (447行目), E-03 (119-125行目) | ○ |
| C-21 | テーブルレンダリングエラー時に IllegalArgumentException/IndexOutOfBoundsException を catch | E-01 (104-111行目) | ○ |
| C-22 | テーブルは折りたたみ可能 (collapse-aggregated-sqlsessionstat) | E-01 (117-129行目) | ○ |
| C-23 | ページネーションは sqlsessionstat タグで管理 | E-01 (89行目: `val sqlTableTag = "sqlsessionstat"`), E-01 (92行目) | ○ |
| C-24 | デフォルトソートは Start Time | E-04 (181行目: `getTableParameters(request, sqlStatsTableTag, "Start Time")`) | ○ |
| C-25 | SparkConnectServerTab で本ページを attachPage | E-02 (44行目: `attachPage(new SparkConnectServerSessionPage(this))`) | ○ |
| C-26 | startTime は applicationInfo().attempts.head.startTime から取得 | E-02 (37-41行目) | ○ |
| C-27 | SparkConnectServerListener が各種イベントをハンドリング | E-05 (118-131行目: `onOtherEvent()`) | ○ |
| C-28 | LiveSessionData.doUpdate() で SessionInfo を生成し KVStore に書き込み | E-05 (442-443行目) | ○ |
| C-29 | LiveExecutionData.doUpdate() で ExecutionInfo を生成し KVStore に書き込み | E-05 (407-422行目) | ○ |
| C-30 | History Server でも利用可能 (SparkConnectServerHistoryServerPlugin) | E-07 (25-41行目) | ○ |
| C-31 | ToolTips で Finish Time, Close Time, Execution, Duration の説明を定義 | E-06 (21-37行目) | ○ |
| C-32 | テストで session ページのロードが検証されている | E-08 (108-133行目: "Spark Connect Server session page should load successfully") | ○ |
| C-33 | ソートは全カラムで可能 (ordering メソッドで14パターン) | E-04 (466-490行目) | ○ |
| C-34 | パフォーマンス要件の目標出力時間はミリ秒〜数秒 | **根拠なし** | △ |
| C-35 | セキュリティは spark.ui.view.acls 等で制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-34: パフォーマンス要件の目標出力時間について、ソースコード上に具体的な SLA やタイムアウト設定は見当たらない。インメモリ KVStore からの読み取りであるため高速と推測しているが、定量的な根拠は存在しない
  - 候補：Spark UI のパフォーマンステストドキュメント / Spark 運用ガイド / ベンチマーク結果
- C-35: セキュリティの ACL 制御について、Spark UI 共通の仕組みとして `spark.ui.view.acls` が存在することは広く知られているが、本帳票固有のソースコード内での ACL チェック実装は確認していない。Spark UI フレームワーク（`WebUI`、`SparkUITab`）側で一括制御される仕組みと推測
  - 候補：`core/src/main/scala/org/apache/spark/ui/WebUI.scala` / Spark セキュリティドキュメント / `SecurityManager` クラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造とフィールド対応（ソースコードから直接確認済み）
- 0: 低リスク - URL パスとルーティング（WebUIPage/SparkUITab から直接確認済み）
- 0: 低リスク - テーブルカラム定義（SqlStatsPagedTable のヘッダー定義から直接確認済み）
- 1: 中リスク - パフォーマンス要件（推測ベース、実測データなし）
- 1: 中リスク - セキュリティ考慮事項（Spark UI 共通仕様からの推測、本帳票固有の検証なし）

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラム定義（14項目）が `SqlStatsPagedTable` の `showSessionLink=false` 時のヘッダー定義と一致しているか
- [ ] `ExecutionState` の7状態の説明が正しいか
- [ ] `Execution Time` と `Duration` の計算ロジックの説明が `totalTime()` メソッドの実装と一致しているか
- [ ] セッション ID でのフィルタリングロジックがソースコードと一致しているか
- [ ] パフォーマンス要件の妥当性（実運用環境での確認が望ましい）
- [ ] セキュリティ要件が組織のポリシーに合致しているか
