---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-StatsdSink メトリクスレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/metrics/sink/StatsdSink.scala` 行29-82
- E-02: `core/src/main/scala/org/apache/spark/metrics/sink/StatsdReporter.scala` 行38-162
- E-03: `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` 行20-24
- E-04: `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` 行97-106, 199-240
- E-05: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行5（No.4 の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StatsdSink はカスタム StatsdReporter を使用 | E-01（行69）, E-02 | ○ |
| C-02 | デフォルト host は 127.0.0.1 | E-01（行37: STATSD_DEFAULT_HOST） | ○ |
| C-03 | デフォルト port は 8125 | E-01（行38: STATSD_DEFAULT_PORT） | ○ |
| C-04 | デフォルト period は 10 | E-01（行39: STATSD_DEFAULT_PERIOD） | ○ |
| C-05 | デフォルト unit は SECONDS | E-01（行40: STATSD_DEFAULT_UNIT） | ○ |
| C-06 | デフォルト prefix は空文字 | E-01（行41: STATSD_DEFAULT_PREFIX） | ○ |
| C-07 | regex フィルタリングが可能 | E-01（行58-65） | ○ |
| C-08 | UDP で送信 | E-02（行67: DatagramSocket, 行144: DatagramPacket） | ○ |
| C-09 | StatsD メトリクスタイプ: c, g, ms, s | E-02（行38-43: StatsdMetricType） | ○ |
| C-10 | Gauge は g タイプで送信 | E-02（行95-96: reportGauge, GAUGE） | ○ |
| C-11 | Counter は c タイプで送信 | E-02（行98-99: reportCounter, COUNTER） | ○ |
| C-12 | Histogram は count(g) + 統計値(ms) で送信 | E-02（行101-115: reportHistogram） | ○ |
| C-13 | Meter は count(g) + レート(ms) で送信 | E-02（行117-123: reportMetered） | ○ |
| C-14 | Timer は Histogram + Meter の複合 | E-02（行125-139: reportTimer → reportMetered） | ○ |
| C-15 | Float/Double は %2.2f でフォーマット | E-02（行154-161: formatAny） | ○ |
| C-16 | ホワイトスペースはハイフンに置換 | E-02（行150: sanitize） | ○ |
| C-17 | report() ごとに新しい DatagramSocket を生成 | E-02（行67: Try(new DatagramSocket)） | ○ |
| C-18 | ソケット生成失敗は WARNING レベルでログ | E-02（行68-69: logWarning） | ○ |
| C-19 | パケット送信失敗は DEBUG レベルでログ | E-02（行83-85: logDebug） | ○ |
| C-20 | start() でログ出力 | E-01（行73: logInfo） | ○ |
| C-21 | stop() でログ出力 | E-01（行78: logInfo） | ○ |
| C-22 | checkMinimalPollingPeriod で検証 | E-01（行67）, E-04（行252-258） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。StatsdReporter は Spark 独自実装であるため、全送信ロジックがソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 全主張にソースコードレベルの根拠あり。低リスク。

## 6) レビュアーチェックリスト（最小）
- [ ] StatsdReporter の各 reportXxx() メソッドの送信内容が設計書と一致するか確認
- [ ] send() メソッドの StatsD フォーマット文字列が正しいか確認
- [ ] エラーハンドリング（Try-Success/Failure）の動作が正確に記述されているか確認
