---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-PrometheusServlet メトリクスレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）。PrometheusServlet は Spark 独自実装であるため、全出力ロジックがソースコードから確認可能。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/metrics/sink/PrometheusServlet.scala` 行42-134
- E-02: `core/src/main/scala/org/apache/spark/metrics/sink/Sink.scala` 行20-24
- E-03: `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` 行84, 89-93, 212-216
- E-04: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行9（No.8 の定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTP エンドポイントで Prometheus テキスト形式を返す | E-01（行49-53: getHandlers, text/plain） | ○ |
| C-02 | @DeveloperApi および @Unstable アノテーション付き | E-01（行40-41） | ○ |
| C-03 | Content-Type は text/plain | E-01（行52: "text/plain"） | ○ |
| C-04 | servletPath はプロパティで設定 | E-01（行47: property.getProperty(SERVLET_KEY_PATH)） | ○ |
| C-05 | normalizeKey で metrics_ プレフィックス + アンダースコア正規化 | E-01（行125-127: s"metrics_${key.replaceAll(...)}_"） | ○ |
| C-06 | Gauge の String 型は除外 | E-01（行70: if (!v.getValue.isInstanceOf[String])） | ○ |
| C-07 | Gauge は Number と Value の2行で出力 | E-01（行71-72） | ○ |
| C-08 | Gauge のラベルは {type="gauges"} | E-01（行62: gaugesLabel） | ○ |
| C-09 | Counter のラベルは {type="counters"} | E-01（行63: countersLabel） | ○ |
| C-10 | Meter のラベルも {type="counters"} | E-01（行64: metersLabel = countersLabel） | ○ |
| C-11 | Histogram のラベルは {type="histograms"} | E-01（行65: histogramslabels） | ○ |
| C-12 | Timer のラベルは {type="timers"} | E-01（行66: timersLabels） | ○ |
| C-13 | Counter は Count のみ出力 | E-01（行75-77） | ○ |
| C-14 | Histogram は Count, Max, Mean, Min, パーセンタイル, StdDev を出力 | E-01（行78-92） | ○ |
| C-15 | Meter は Count, MeanRate, OneMinuteRate, FiveMinuteRate, FifteenMinuteRate を出力 | E-01（行93-101） | ○ |
| C-16 | Timer は統計値 + Rate を出力 | E-01（行102-121） | ○ |
| C-17 | start()/stop()/report() は空実装 | E-01（行129-133） | ○ |
| C-18 | MetricsSystem で prometheusServlet として特別扱い | E-03（行212-216） | ○ |
| C-19 | getServletHandlers で Jetty ハンドラを返す | E-03（行89-93） | ○ |
| C-20 | StringBuilder で直接テキスト生成 | E-01（行68: new StringBuilder()） | ○ |
| C-21 | @Since("4.0.0") 付きの引数なし getMetricsSnapshot() | E-01（行58-59） | ○ |
| C-22 | Sink トレイトを実装 | E-01, E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。PrometheusServlet は Spark 独自実装であり、全出力ロジックがソースコードから確認可能。

## 5) リスクフラグ（レビュー観点）
- 0: 全主張にソースコードレベルの根拠あり
- 1: @Unstable API のため、バージョンアップ時の互換性に注意

## 6) レビュアーチェックリスト（最小）
- [ ] normalizeKey() の正規化ルールが正確に記述されているか確認
- [ ] 各メトリクスタイプの出力行数・内容が実際のコードと一致するか確認
- [ ] Meter のラベルが "counters" である点が正しく記述されているか確認
- [ ] String 型 Gauge の除外条件が正しく記述されているか確認
