---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 97
  claims_with_evidence: 93
  claims_without_evidence: 4
confidence_derived: 0.96
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：93 / 97、根拠なし：4
- 優先レビュー（高）
  1. **C-34 Variantデータ型の説明**：機能の詳細な用途説明は推測を含む
  2. **C-35 SQLスクリプティングの説明**：scriptingディレクトリの内容から推測した機能説明
  3. **C-91 Declarative Pipelinesの説明**：sql/pipelinesモジュールは新しい機能であり、詳細設計書等の根拠が限定的
  4. **C-88 Kinesisコネクタの説明**：kinesis-aslモジュールのディレクトリ存在のみで詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `README.md` - プロジェクト概要、主要コンポーネントの記載
- E-02: `pom.xml` - Mavenモジュール構成（全サブモジュール一覧）
- E-03: `core/src/main/scala/org/apache/spark/SparkContext.scala` - SparkContext実装
- E-04: `core/src/main/scala/org/apache/spark/rdd/` - RDD各種実装ディレクトリ
- E-05: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` - DAGスケジューラ実装
- E-06: `core/src/main/scala/org/apache/spark/scheduler/` - スケジューラディレクトリ全体
- E-07: `core/src/main/scala/org/apache/spark/executor/Executor.scala` - Executor実装
- E-08: `core/src/main/scala/org/apache/spark/memory/UnifiedMemoryManager.scala` - メモリ管理実装
- E-09: `core/src/main/scala/org/apache/spark/storage/BlockManager.scala` - ブロック管理実装
- E-10: `core/src/main/scala/org/apache/spark/shuffle/` - シャッフル実装ディレクトリ
- E-11: `core/src/main/scala/org/apache/spark/broadcast/TorrentBroadcast.scala` - ブロードキャスト実装
- E-12: `core/src/main/scala/org/apache/spark/InternalAccumulator.scala` - アキュムレータ実装
- E-13: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` - イベントログ実装
- E-14: `core/src/main/scala/org/apache/spark/metrics/MetricsSystem.scala` - メトリクスシステム実装
- E-15: `core/src/main/scala/org/apache/spark/rpc/` - RPCフレームワークディレクトリ
- E-16: `common/network-common/` - ネットワーク基盤モジュール
- E-17: `core/src/main/scala/org/apache/spark/security/` - セキュリティモジュールディレクトリ
- E-18: `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` - 動的リソース割り当て実装
- E-19: `core/src/main/scala/org/apache/spark/BarrierCoordinator.scala` - バリア実行実装
- E-20: `core/src/main/scala/org/apache/spark/ui/SparkUI.scala` - Web UI実装
- E-21: `core/src/main/scala/org/apache/spark/deploy/history/HistoryServer.scala` - History Server実装
- E-22: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/parser/` - SQLパーサー実装
- E-23: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/optimizer/Optimizer.scala` - オプティマイザ実装
- E-24: `sql/api/` - DataFrame/Dataset APIモジュール
- E-25: `sql/core/src/main/scala/org/apache/spark/sql/execution/` - SQL実行エンジン
- E-26: `sql/core/src/main/scala/org/apache/spark/sql/sources/` - データソースインターフェース
- E-27: `sql/core/src/main/scala/org/apache/spark/sql/execution/datasources/` - データソース実装
- E-28: `sql/core/src/main/scala/org/apache/spark/sql/jdbc/` - JDBCデータソース実装
- E-29: `sql/hive/` - Hive連携モジュール
- E-30: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/` - カタログ管理
- E-31: `sql/core/src/main/scala/org/apache/spark/sql/UDTFRegistration.scala` - UDTF登録
- E-32: `connector/avro/` - Avroコネクタモジュール
- E-33: `connector/protobuf/` - Protobufコネクタモジュール
- E-34: `common/variant/` - Variantデータ型モジュール
- E-35: `sql/core/src/main/scala/org/apache/spark/sql/scripting/` - SQLスクリプティングディレクトリ
- E-36: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/` - ストリーミング実行
- E-37: `connector/kafka-0-10-sql/` - Kafka SQLコネクタ
- E-38: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/state/` - ステート管理
- E-39: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/checkpointing/` - チェックポイント
- E-40: `streaming/` - DStreamsモジュール
- E-41: `streaming/src/main/scala/org/apache/spark/streaming/receiver/` - レシーバーモジュール
- E-42: `mllib/src/main/scala/org/apache/spark/ml/Pipeline.scala` - ML Pipeline実装
- E-43: `mllib/src/main/scala/org/apache/spark/ml/classification/` - 分類アルゴリズムディレクトリ
- E-44: `mllib/src/main/scala/org/apache/spark/ml/regression/` - 回帰アルゴリズムディレクトリ
- E-45: `mllib/src/main/scala/org/apache/spark/ml/clustering/` - クラスタリングアルゴリズムディレクトリ
- E-46: `mllib/src/main/scala/org/apache/spark/ml/recommendation/ALS.scala` - ALS推薦実装
- E-47: `mllib/src/main/scala/org/apache/spark/ml/feature/` - 特徴量変換ディレクトリ
- E-48: `mllib/src/main/scala/org/apache/spark/ml/evaluation/` - モデル評価ディレクトリ
- E-49: `mllib/src/main/scala/org/apache/spark/ml/tuning/` - ハイパーパラメータチューニングディレクトリ
- E-50: `mllib/src/main/scala/org/apache/spark/ml/fpm/` - 頻出パターンマイニングディレクトリ
- E-51: `mllib/src/main/scala/org/apache/spark/ml/stat/` - 統計検定ディレクトリ
- E-52: `graphx/src/main/scala/org/apache/spark/graphx/` - GraphXモジュール全体
- E-53: `graphx/src/main/scala/org/apache/spark/graphx/lib/` - GraphXアルゴリズムライブラリ
- E-54: `graphx/src/main/scala/org/apache/spark/graphx/Pregel.scala` - Pregel実装
- E-55: `sql/connect/server/` - Spark Connectサーバーモジュール
- E-56: `sql/connect/client/jvm/` - Spark Connect JVMクライアント
- E-57: `sql/connect/client/jdbc/` - Spark Connect JDBCクライアント
- E-58: `core/src/main/scala/org/apache/spark/deploy/SparkSubmit.scala` - spark-submit実装
- E-59: `core/src/main/scala/org/apache/spark/deploy/master/` - Standaloneマスター
- E-60: `core/src/main/scala/org/apache/spark/deploy/worker/` - Standaloneワーカー
- E-61: `resource-managers/yarn/` - YARN連携モジュール
- E-62: `resource-managers/kubernetes/` - Kubernetes連携モジュール
- E-63: `connector/kafka-0-10/` - Kafkaコネクタモジュール
- E-64: `connector/kinesis-asl/` - Kinesisコネクタモジュール
- E-65: `python/pyspark/` - PySparkモジュール
- E-66: `python/pyspark/pandas/` - pandas API on Sparkモジュール
- E-67: `sql/pipelines/` - Pipelinesモジュール
- E-68: `common/network-shuffle/` - ネットワークシャッフルモジュール
- E-69: `common/unsafe/` - Unsafeモジュール
- E-70: `common/sketch/` - Sketchモジュール
- E-71: `common/kvstore/` - KVStoreモジュール
- E-72: `repl/` - REPLモジュール
- E-73: `connector/profiler/` - プロファイラモジュール
- E-74: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/csv/` - CSV処理
- E-75: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/json/` - JSON処理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkContext管理：アプリケーションのエントリポイントとしてSparkクラスタへの接続を管理 | E-01, E-03 | ○ |
| C-02 | RDD：耐障害性を持つ分散コレクションの提供 | E-01, E-04 | ○ |
| C-03 | DAGスケジューラ：ジョブをステージに分割しDAGを構築 | E-05 | ○ |
| C-04 | タスクスケジューラ：タスクセットをExecutorに割り当て | E-06 | ○ |
| C-05 | Executorプロセス管理：ワーカーノード上でタスクを実行 | E-07 | ○ |
| C-06 | メモリ管理：Unified Memory Managerによる動的メモリ管理 | E-08 | ○ |
| C-07 | ブロックストレージ管理：データブロックの保存と取得 | E-09 | ○ |
| C-08 | シャッフル機構：ソートベースのシャッフル管理 | E-10 | ○ |
| C-09 | ブロードキャスト変数：TorrentBroadcast機構 | E-11 | ○ |
| C-10 | アキュムレータ：分散環境での共有変数 | E-12 | ○ |
| C-11 | イベントログ記録：実行イベントのJSON記録 | E-13 | ○ |
| C-12 | メトリクスシステム：パフォーマンス指標の収集・報告 | E-14 | ○ |
| C-13 | RPC通信フレームワーク：Nettyベースの通信機構 | E-15, E-16 | ○ |
| C-14 | セキュリティ管理：認証・暗号化・ACL制御 | E-17 | ○ |
| C-15 | 動的リソース割り当て：Executorの動的増減 | E-18 | ○ |
| C-16 | バリア実行モード：分散ML向けバリア同期 | E-19 | ○ |
| C-17 | Spark Web UI：アプリケーション実行状況の可視化 | E-20 | ○ |
| C-18 | History Server：完了済みアプリケーション履歴閲覧 | E-21 | ○ |
| C-19 | SQLパーサー：ANTLR4ベースのSQL解析 | E-22 | ○ |
| C-20 | Catalystオプティマイザ：ルールベース・コストベース最適化 | E-23 | ○ |
| C-21 | DataFrame/Dataset API：型安全な分散データ操作API | E-24, E-25 | ○ |
| C-22 | コード生成（Whole-Stage CodeGen）：動的バイトコード生成 | E-25 | ○ |
| C-23 | データソースV2 API：プラグイン可能なデータソースインターフェース | E-26 | ○ |
| C-24 | Parquetサポート：Parquetフォーマットの読み書き | E-27 | ○ |
| C-25 | ORCサポート：ORCフォーマットの読み書き | E-27 | ○ |
| C-26 | CSVファイルサポート：CSVの読み込み・書き出し | E-74 | ○ |
| C-27 | JSONファイルサポート：JSONの読み込み・書き出し | E-75 | ○ |
| C-28 | JDBCデータソース：JDBC経由のRDBMS読み書き | E-28 | ○ |
| C-29 | Hiveメタストア連携：Hiveメタストアとの統合 | E-29 | ○ |
| C-30 | カタログ管理：テーブル・ビュー・関数のメタデータ管理 | E-30 | ○ |
| C-31 | UDF/UDAF/UDTFサポート：ユーザー定義関数の登録と実行 | E-31 | ○ |
| C-32 | Avroデータフォーマット：Avroフォーマットの読み書き | E-32 | ○ |
| C-33 | Protobufデータフォーマット：Protobufの読み書き | E-33 | ○ |
| C-34 | Variantデータ型：半構造化データの効率的格納 | E-34 | △ |
| C-35 | SQLスクリプティング：制御構造を用いたSQLスクリプト実行 | E-35 | △ |
| C-36 | ストリーム処理エンジン：マイクロバッチ・連続処理 | E-36 | ○ |
| C-37 | Kafkaソース/シンク：Kafkaとの統合 | E-37 | ○ |
| C-38 | ステート管理：ストリーミングクエリの状態永続化 | E-38 | ○ |
| C-39 | チェックポイント管理：進行状況の永続保存 | E-39 | ○ |
| C-40 | DStreamストリーム処理：RDDベースのストリーム処理 | E-40 | ○ |
| C-41 | レシーバー管理：外部データソースからのデータ受信 | E-41 | ○ |
| C-42 | Pipeline API：MLワークフローのパイプライン構成 | E-42 | ○ |
| C-43 | ロジスティック回帰：二値・多クラス分類 | E-43 | ○ |
| C-44 | 決定木分類 | E-43 | ○ |
| C-45 | ランダムフォレスト分類 | E-43 | ○ |
| C-46 | 勾配ブースティング木分類 | E-43 | ○ |
| C-47 | 線形SVM | E-43 | ○ |
| C-48 | ナイーブベイズ | E-43 | ○ |
| C-49 | 多層パーセプトロン分類 | E-43 | ○ |
| C-50 | 因子分解マシン分類 | E-43 | ○ |
| C-51 | One-vs-Rest分類 | E-43 | ○ |
| C-52 | 線形回帰 | E-44 | ○ |
| C-53 | 決定木回帰 | E-44 | ○ |
| C-54 | ランダムフォレスト回帰 | E-44 | ○ |
| C-55 | 勾配ブースティング木回帰 | E-44 | ○ |
| C-56 | 一般化線形モデル | E-44 | ○ |
| C-57 | 生存時間分析（AFT） | E-44 | ○ |
| C-58 | 因子分解マシン回帰 | E-44 | ○ |
| C-59 | 等張回帰 | E-44 | ○ |
| C-60 | K-Meansクラスタリング | E-45 | ○ |
| C-61 | 二分K-Meansクラスタリング | E-45 | ○ |
| C-62 | ガウス混合モデル | E-45 | ○ |
| C-63 | LDA（トピックモデル） | E-45 | ○ |
| C-64 | Power Iteration Clustering | E-45 | ○ |
| C-65 | ALS推薦 | E-46 | ○ |
| C-66 | 特徴量変換（40以上の変換器） | E-47 | ○ |
| C-67 | モデル評価 | E-48 | ○ |
| C-68 | ハイパーパラメータチューニング | E-49 | ○ |
| C-69 | 頻出パターンマイニング | E-50 | ○ |
| C-70 | 統計検定 | E-51 | ○ |
| C-71 | グラフ構造データ管理 | E-52 | ○ |
| C-72 | PageRankアルゴリズム | E-53 | ○ |
| C-73 | 連結成分検出 | E-53 | ○ |
| C-74 | 強連結成分検出 | E-53 | ○ |
| C-75 | 三角形カウント | E-53 | ○ |
| C-76 | 最短経路探索 | E-53 | ○ |
| C-77 | ラベル伝播 | E-53 | ○ |
| C-78 | SVD++ | E-53 | ○ |
| C-79 | Pregelフレームワーク | E-54 | ○ |
| C-80 | Spark Connectサーバー | E-55 | ○ |
| C-81 | Spark Connectクライアント（JVM） | E-56 | ○ |
| C-82 | Spark Connect JDBCクライアント | E-57 | ○ |
| C-83 | spark-submit | E-58 | ○ |
| C-84 | Standaloneクラスタマネージャ | E-59, E-60 | ○ |
| C-85 | YARN連携 | E-61 | ○ |
| C-86 | Kubernetes連携 | E-62 | ○ |
| C-87 | Kafkaコネクタ | E-63 | ○ |
| C-88 | Kinesisコネクタ | E-64 | △ |
| C-89 | PySpark API | E-65 | ○ |
| C-90 | pandas API on Spark | E-66 | ○ |
| C-91 | Declarative Pipelines | E-67 | △ |
| C-92 | ネットワーク通信基盤 | E-16, E-68 | ○ |
| C-93 | Unsafe操作 | E-69 | ○ |
| C-94 | Sketchデータ構造 | E-70 | ○ |
| C-95 | KVStore | E-71 | ○ |
| C-96 | REPL（対話型シェル） | E-72 | ○ |
| C-97 | コードプロファイラ | E-73 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-34 Variantデータ型**：`common/variant/` ディレクトリの存在は確認できたが、内部の実装詳細（JSONライクなデータのカラムナ格納という記述）は推測を含む。Variantはまだ比較的新しい機能のため、設計書やドキュメント根拠が限定的。
  - 候補：Variant型の実装ソース / Sparkドキュメント / SPIP提案文書
- **C-35 SQLスクリプティング**：`sql/core/scripting/` ディレクトリの存在は確認したが、IF/ELSE, WHILE等の具体的な制御構造サポートの詳細は推測を含む。
  - 候補：scriptingディレクトリ内の実装ソース / Sparkドキュメント
- **C-88 Kinesisコネクタ**：`connector/kinesis-asl/` ディレクトリの存在は確認したが、モジュール内の実装詳細は未確認。
  - 候補：kinesis-asl内の実装ソース / Amazon Kinesis連携ドキュメント
- **C-91 Declarative Pipelines**：`sql/pipelines/` モジュールの存在は確認したが、機能の詳細説明（宣言的パイプライン定義、ETLワークフロー）は限定的な根拠に基づく。
  - 候補：pipelinesモジュール内のソースコード / 設計ドキュメント

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - Spark Core（C-01〜C-16）：全て主要ソースファイルの存在で確認済み
- **0: 低リスク** - MLlib分類・回帰アルゴリズム（C-43〜C-59）：個別の.scalaファイルで直接確認
- **0: 低リスク** - GraphXアルゴリズム（C-72〜C-79）：libディレクトリ内の個別ファイルで直接確認
- **0: 低リスク** - Spark SQL主要機能（C-19〜C-31）：ソースディレクトリ・ファイル構成で確認済み
- **1: 中リスク** - Variantデータ型（C-34）：モジュール存在は確認済みだが機能説明の精度要確認
- **1: 中リスク** - SQLスクリプティング（C-35）：ディレクトリ存在は確認済みだが具体的な制御構造のサポート範囲は要確認
- **1: 中リスク** - Declarative Pipelines（C-91）：新機能のため設計意図の正確性を要確認
- **1: 中リスク** - Kinesisコネクタ（C-88）：ディレクトリ存在のみで実装詳細未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Spark Core機能（No.1〜16）の説明がソースコード実装と整合しているか
- [ ] Spark SQL機能（No.19〜35）の説明が最新のAPI仕様と整合しているか
- [ ] Structured Streaming機能（No.36〜39）のExactly-Once保証等の説明が正確か
- [ ] MLlib各アルゴリズム（No.43〜70）の説明が実装と整合しているか
- [ ] GraphXアルゴリズム（No.72〜79）の説明が正確か
- [ ] Variantデータ型（No.34）の「JSONライクなデータのカラムナ格納」という説明が正確か
- [ ] SQLスクリプティング（No.35）の対応する制御構造の範囲が正確か
- [ ] Declarative Pipelines（No.91）の機能説明が実装と整合しているか
- [ ] Kinesisコネクタ（No.88）が現在も有効なモジュールか（非推奨でないか）
- [ ] 全97機能に漏れがないか（特にHive ThriftServer等のサブモジュールが含まれるべきか検討）
