# 機能設計書 14-セキュリティ管理

## 概要

本ドキュメントは、Apache Sparkのセキュリティ管理機能について、認証・暗号化・ACLによるアクセス制御の設計仕様を記述した機能設計書である。

### 本機能の処理概要

認証（Authentication）、暗号化（Encryption）、ACL（Access Control List）によるアクセス制御を包括的に提供し、クラスタ通信とWeb UIのセキュリティを確保する。SecurityManagerクラスを中心に、ネットワーク認証、I/O暗号化、UIアクセス制御、Hadoop委任トークン管理を統合管理する。

**業務上の目的・背景**：マルチテナント環境やセキュリティ要件の高い本番環境において、(1) 不正なクライアントからのアクセスを防止し、(2) 通信データの盗聴・改ざんを防止し、(3) Web UIの閲覧・操作権限を適切に管理する必要がある。

**機能の利用シーン**：(1) Kerberized Hadoop環境でのSparkアプリケーション実行、(2) YARN/Kubernetes上でのセキュアなジョブ実行、(3) Web UIのアクセス制御設定、(4) シャッフルデータやブロック転送の暗号化。

**主要な処理内容**：
1. SecurityManagerによるACL管理（view/modify権限のユーザー・グループ制御）
2. ネットワーク認証（spark.authenticate）の有効化とシークレットキー管理
3. I/O暗号化（CryptoStreamUtils）によるデータストリームの暗号化・復号
4. Hadoop委任トークンの取得・更新管理（HadoopDelegationTokenManager）
5. SSL/TLS通信設定のサポート
6. Socket認証（SocketAuthHelper/SocketAuthServer）

**関連システム・外部連携**：Hadoop KMS（暗号化キー管理）、Kerberos KDC、HDFS、YARN

**権限による制御**：ACL設定により、Web UIの閲覧（view）と操作（modify、ジョブのkill等）を個別に制御可能。管理者ACL（adminAcls）は全権限を持つ。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 9 | Environment（環境情報） | 補助機能 | セキュリティ関連のSparkプロパティ値を機密情報マスク処理（Utils.redact）して表示 |

## 機能種別

セキュリティ基盤 / アクセス制御

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| spark.authenticate | Boolean | No | ネットワーク認証の有効化 | デフォルト: false |
| spark.acls.enable | Boolean | No | ACLの有効化 | デフォルト: false |
| spark.admin.acls | String | No | 管理者ユーザーリスト | カンマ区切り |
| spark.admin.acls.groups | String | No | 管理者グループリスト | カンマ区切り |
| spark.ui.view.acls | String | No | UI閲覧許可ユーザー | カンマ区切り |
| spark.ui.view.acls.groups | String | No | UI閲覧許可グループ | カンマ区切り |
| spark.modify.acls | String | No | 変更操作許可ユーザー | カンマ区切り |
| spark.modify.acls.groups | String | No | 変更操作許可グループ | カンマ区切り |
| spark.ssl.rpc.enabled | Boolean | No | RPC SSL/TLS有効化 | デフォルト: false |
| spark.io.encryption.enabled | Boolean | No | I/O暗号化有効化 | デフォルト: false |

### 入力データソース

SparkConf設定値、Hadoopの認証情報（Credentials、UserGroupInformation）。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| 認証結果 | Boolean | checkUIViewPermissions/checkModifyPermissionsの結果 |
| 暗号化ストリーム | CryptoOutputStream/CryptoInputStream | 暗号化されたI/Oストリーム |
| 委任トークン | Credentials | Hadoop委任トークン |

### 出力先

認証・認可結果はWeb UIおよびRPCレイヤーに返却。暗号化ストリームはI/O処理に適用。

## 処理フロー

### 処理シーケンス

```
1. SecurityManagerの初期化
   └─ SparkConf読み込み、ACLの設定、認証モードの確認
2. ACL設定
   └─ デフォルトACLユーザー（現在のユーザー + SPARK_USER）+ 設定値でACLリスト構築
3. 認証シークレットの管理
   └─ シークレットファイルまたはHadoop Credentialsからシークレットキーを取得
4. I/O暗号化（有効時）
   └─ CryptoStreamUtilsでAES暗号化ストリームを生成
5. 委任トークン管理（Kerberos環境）
   └─ HadoopDelegationTokenManagerでトークンの取得・更新
6. アクセス権チェック
   └─ checkUIViewPermissions / checkModifyPermissions でACL照合
```

### フローチャート

```mermaid
flowchart TD
    A[SecurityManager初期化] --> B[ACL設定読み込み]
    B --> C{認証有効?}
    C -->|Yes| D[シークレットキー取得]
    C -->|No| E[認証スキップ]
    D --> F{暗号化有効?}
    E --> F
    F -->|Yes| G[暗号化キー生成]
    F -->|No| H[暗号化スキップ]
    G --> I[アクセス権チェック準備完了]
    H --> I
    I --> J{Web UIアクセス}
    J --> K[checkUIViewPermissions]
    K --> L{ACL照合}
    L -->|許可| M[アクセス許可]
    L -->|拒否| N[アクセス拒否]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-14-01 | デフォルトACLユーザー | 現在のシステムユーザーとSPARK_USERは常にACLに含まれる | ACL有効時 |
| BR-14-02 | ワイルドカードACL | "*"を指定すると全ユーザーにアクセスを許可 | ACL設定時 |
| BR-14-03 | 管理者権限 | adminAclsに含まれるユーザーはview/modify両方の権限を持つ | ACL有効時 |
| BR-14-04 | 機密情報リダクション | パスワード等の機密プロパティはUI表示時にマスクされる | 環境情報表示時 |
| BR-14-05 | 暗号化IV長 | 初期化ベクトルの長さは16バイト固定 | I/O暗号化使用時 |

### 計算ロジック

該当なし

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | SecurityException | 認証失敗 | 接続拒否 |
| - | IOException | 暗号化ストリームのI/Oエラー | 例外を上位に伝播 |
| - | NoSuchElementException | Kerberos設定の必須パラメータ欠落 | 例外スロー |

### リトライ仕様

委任トークンの更新は定期的に自動実行される。認証失敗時のリトライはフレームワーク側では行わない。

## トランザクション仕様

該当なし

## パフォーマンス要件

I/O暗号化はAES暗号を使用し、Apache Commons Cryptoライブラリのネイティブ実装により高パフォーマンスを実現。暗号化オーバーヘッドは通常のI/O処理の10-20%程度。

## セキュリティ考慮事項

- シークレットキーはファイルまたはHadoop Credentialsで管理し、設定ファイルに平文で記載しない
- SSL/TLS証明書の適切な管理が必要
- ACLは必要最小限の権限付与を推奨

## 備考

- SecurityManagerはSparkEnvから取得するのが標準的な使用方法
- History Server用のSecurityManager生成時にはspark.authenticateを自動的にfalseに設定
- GroupMappingServiceProviderでユーザーのグループ所属を解決

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SecurityManager.scala | `core/src/main/scala/org/apache/spark/SecurityManager.scala` | ACLフィールド（viewAcls, modifyAcls, adminAcls等）の定義を確認 |

**読解のコツ**: SecurityManagerはSecretKeyHolderトレイトも実装しており、認証シークレットの提供者でもある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SecurityManager.scala | `core/src/main/scala/org/apache/spark/SecurityManager.scala` | コンストラクタでの設定読み込み、setViewAcls/setModifyAclsの呼び出し |

**主要処理フロー**:
1. **47-51行目**: コンストラクタ引数（sparkConf, ioEncryptionKey, authSecretFileConf）
2. **58-59行目**: authOn, aclsOnフラグの設定
3. **62-75行目**: adminAcls, viewAcls, modifyAclsの初期化
4. **78-85行目**: デフォルトACLユーザーの設定とACL適用
5. **89-90行目**: SSL RPC設定の読み込み

#### Step 3: 暗号化処理層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CryptoStreamUtils.scala | `core/src/main/scala/org/apache/spark/security/CryptoStreamUtils.scala` | I/O暗号化のストリームラッパー生成処理 |

**主要処理フロー**:
- **44行目**: IV_LENGTH_IN_BYTES = 16（初期化ベクトル長）
- **51-60行目**: createCryptoOutputStream()でAES暗号化出力ストリーム生成
- **79行目以降**: createCryptoInputStream()で復号入力ストリーム生成

#### Step 4: 委任トークン管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HadoopDelegationTokenManager.scala | `core/src/main/scala/org/apache/spark/deploy/security/HadoopDelegationTokenManager.scala` | Hadoop委任トークンの取得・更新ロジック |
| 4-2 | HadoopFSDelegationTokenProvider.scala | `core/src/main/scala/org/apache/spark/deploy/security/HadoopFSDelegationTokenProvider.scala` | HDFS委任トークンプロバイダー |

### プログラム呼び出し階層図

```
SparkEnv
    │
    ├─ SecurityManager
    │      ├─ ACL管理 (viewAcls, modifyAcls, adminAcls)
    │      │    ├─ checkUIViewPermissions()
    │      │    └─ checkModifyPermissions()
    │      │
    │      ├─ 認証管理 (SecretKeyHolder)
    │      │    ├─ getSecretKey()
    │      │    └─ getSaslUser()
    │      │
    │      └─ SSLオプション管理
    │           └─ getSSLOptions(module)
    │
    ├─ CryptoStreamUtils
    │      ├─ createCryptoOutputStream() ─ AES暗号化
    │      ├─ createCryptoInputStream() ─ AES復号
    │      └─ createInitializationVector() ─ IV生成
    │
    └─ HadoopDelegationTokenManager
           ├─ obtainDelegationTokens() ─ トークン取得
           └─ renewDelegationTokens() ─ トークン更新
```

### データフロー図

```
[入力]                         [処理]                       [出力]

SparkConf (設定)     ───▶ SecurityManager        ───▶ ACL判定結果
                           ├─ ACL設定                   (Boolean)
                           └─ 認証設定

平文データストリーム ───▶ CryptoStreamUtils      ───▶ 暗号化ストリーム
暗号化キー            ├─ AES暗号化
                       └─ IV生成

Kerberos TGT        ───▶ HadoopDelegationTokenManager ───▶ Hadoop委任トークン
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SecurityManager.scala | `core/src/main/scala/org/apache/spark/SecurityManager.scala` | ソース | セキュリティ管理のメインクラス |
| CryptoStreamUtils.scala | `core/src/main/scala/org/apache/spark/security/CryptoStreamUtils.scala` | ソース | I/O暗号化ユーティリティ |
| SocketAuthHelper.scala | `core/src/main/scala/org/apache/spark/security/SocketAuthHelper.scala` | ソース | Socket認証ヘルパー |
| SocketAuthServer.scala | `core/src/main/scala/org/apache/spark/security/SocketAuthServer.scala` | ソース | Socket認証サーバー |
| GroupMappingServiceProvider.scala | `core/src/main/scala/org/apache/spark/security/GroupMappingServiceProvider.scala` | ソース | ユーザーグループマッピング |
| ShellBasedGroupsMappingProvider.scala | `core/src/main/scala/org/apache/spark/security/ShellBasedGroupsMappingProvider.scala` | ソース | シェルコマンドベースのグループ解決 |
| HadoopDelegationTokenManager.scala | `core/src/main/scala/org/apache/spark/deploy/security/HadoopDelegationTokenManager.scala` | ソース | Hadoop委任トークン管理 |
| SecurityConfigurationLock.scala | `core/src/main/scala/org/apache/spark/security/SecurityConfigurationLock.scala` | ソース | セキュリティ設定のロック管理 |
