# 機能設計書 29-Hiveメタストア連携

## 概要

本ドキュメントは、Apache SparkにおけるApache Hiveのメタストアとの統合機能の設計について記述する。Hiveテーブルのメタデータ管理とHiveQL互換のクエリ実行を可能にする。

### 本機能の処理概要

SparkのHiveメタストア連携は、Apache HiveのメタストアサービスとSpark SQLを統合し、Hiveで管理されるテーブル、パーティション、関数等のメタデータをSpark SQLから透過的に利用可能にする。HiveExternalCatalogがSparkのExternalCatalogインターフェースを実装し、Hiveメタストアへのメタデータ操作を橋渡しする。また、HiveメタストアCatalog（HiveMetastoreCatalog）がHiveテーブルの解析とSparkプランへの変換を担当する。

**業務上の目的・背景**：多くの企業がApache Hiveを用いたデータウェアハウスを構築・運用している。SparkのHiveメタストア連携により、既存のHiveテーブル定義やメタデータ資産をそのまま活用し、Sparkの高速な実行エンジンでHiveクエリを処理できる。これにより、HiveからSparkへの移行コストを最小化しつつ、パフォーマンスを向上させる。

**機能の利用シーン**：Hiveデータウェアハウスの高速化、Hiveテーブルのメタデータ管理、HiveQL互換クエリの実行、Hive UDFの利用、パーティション管理。

**主要な処理内容**：
1. HiveExternalCatalogによるHiveメタストアへのメタデータCRUD操作
2. HiveMetastoreCatalogによるHiveテーブルのSparkプランへの変換
3. HiveSessionCatalogによるセッションスコープのカタログ管理
4. HiveClientによるHiveメタストアAPIへの接続
5. HiveInspectorsによるHive型とSpark型の相互変換
6. HiveStrategiesによるHiveテーブル操作の物理プラン生成
7. Hive UDF/UDAF/UDTFの実行サポート

**関連システム・外部連携**：Apache Hive Metastore（Thrift API）、Hadoop FileSystem API、HiveSerDe（シリアライゼーション/デシリアライゼーション）

**権限による制御**：Hiveメタストアの認証・認可機構（HiveServer2のACL等）に依存。Kerberos認証によるセキュアアクセスに対応。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 22 | ThriftServer Overview（ThriftServer概要） | 主機能 | ThriftServerAppStatusStoreからHive ThriftServerのセッション数・SQL統計を取得して表示 |
| 23 | ThriftServer Session Detail（ThriftServerセッション詳細） | 主機能 | セッションのユーザー・IPアドレス・実行SQL一覧を取得して表示 |

## 機能種別

データ連携 / メタデータ管理 / 外部システム連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| spark.sql.catalogImplementation | String | No | カタログ実装（"hive"でHive有効化） | "hive" or "in-memory" |
| hive.metastore.uris | String | No | Hiveメタストア接続URI | 有効なThrift URI |
| spark.sql.warehouse.dir | String | No | Hiveウェアハウスディレクトリ | 有効なディレクトリパス |
| spark.sql.hive.metastore.version | String | No | Hiveメタストアバージョン | サポートバージョン |
| spark.sql.hive.metastore.jars | String | No | Hiveメタストア接続用JARパス | 有効なパス |

### 入力データソース

- Apache Hive Metastore（Thrift API経由）
- Hadoop互換ファイルシステム上のHiveテーブルデータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CatalogTable | CatalogTable | テーブルメタデータ |
| DataFrame | Dataset[Row] | Hiveテーブルから読み込まれたデータ |
| CatalogDatabase | CatalogDatabase | データベースメタデータ |

### 出力先

- Hiveメタストア（メタデータの更新）
- DataFrame/Dataset（クエリ結果）
- Hadoop互換ファイルシステム（テーブルデータの書き込み）

## 処理フロー

### 処理シーケンス

```
1. HiveClientの初期化
   └─ HiveUtils.newClientForMetadata()によるHiveメタストア接続の確立
2. HiveExternalCatalogの初期化
   └─ ExternalCatalogインターフェースの実装、HiveClient経由でメタストア操作
3. テーブルメタデータの取得
   └─ HiveExternalCatalog.getTable()によるCatalogTableの取得
4. HiveMetastoreCatalogによるプラン変換
   └─ HiveテーブルリレーションをSparkの論理プランに変換
5. HiveStrategiesによる物理プラン生成
   └─ HiveテーブルスキャンやInsertIntoHiveTable等の物理プラン
6. データの読み取り/書き込み
   └─ HiveSerDe + FileFormat経由でのデータI/O
```

### フローチャート

```mermaid
flowchart TD
    A[SparkSession.enableHiveSupport] --> B[HiveClient初期化]
    B --> C[HiveExternalCatalog]
    C --> D[Hiveメタストア接続]
    D --> E{操作種別}
    E -->|テーブル読み取り| F[HiveMetastoreCatalog]
    E -->|メタデータ操作| G[ExternalCatalog API]
    E -->|DDL| H[HiveSessionStateBuilder]
    F --> I[HiveTableRelationResolver]
    I --> J[HiveStrategies]
    J --> K[物理実行計画]
    G --> L[Hiveメタストア更新]
    H --> L
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-29-01 | スレッドセーフ | HiveExternalCatalogの全publicメソッドはsynchronizedで保護 | 全メタデータ操作 |
| BR-29-02 | Hive例外ラップ | HiveException/TException等のHive例外はSparkExceptionにラップ | Hiveメタストア操作エラー時 |
| BR-29-03 | DDL_TIME更新 | テーブル操作時にDDL_TIMEメタデータが更新される | テーブルCRUD操作時 |
| BR-29-04 | SERIALIZATION_FORMAT | Hive互換のシリアライゼーション形式が維持される | テーブル作成/変更時 |

### 計算ロジック

HiveMetastoreCatalogはHiveテーブルのストレージ形式（SerDe）に基づいて適切なFileFormatに変換する。Parquet/ORC/テキスト等のフォーマットはSparkのネイティブリーダーで処理され、それ以外はHiveのSerDeを使用する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| createTable | Hiveメタストア | CREATE | テーブルメタデータの作成 |
| dropTable | Hiveメタストア | DROP | テーブルメタデータの削除 |
| alterTable | Hiveメタストア | ALTER | テーブルメタデータの変更 |
| getTable | Hiveメタストア | SELECT | テーブルメタデータの取得 |
| createPartitions | Hiveメタストア | CREATE | パーティション追加 |
| dropPartitions | Hiveメタストア | DROP | パーティション削除 |

### テーブル別操作詳細

#### Hiveメタストア

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE | テーブル定義全体 | CatalogTableオブジェクト | DDL_TIME自動設定 |
| ALTER | テーブル定義の変更部分 | 変更されたCatalogTable | DDL_TIME自動更新 |
| SELECT | テーブル定義全体 | データベース名+テーブル名 | キャッシュ適用可 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| METASTORE_CONNECTION_FAILURE | 接続エラー | Hiveメタストアへの接続失敗 | メタストアURI/ネットワーク確認 |
| TABLE_ALREADY_EXISTS | 重複エラー | 既存テーブル名での作成試行 | テーブル名の確認、IF NOT EXISTS使用 |
| TABLE_OR_VIEW_NOT_FOUND | 未検出エラー | テーブルが存在しない | テーブル名/データベース名の確認 |
| HIVE_EXCEPTION | Hiveエラー | Hive固有の例外発生 | Hiveメタストアログの確認 |

### リトライ仕様

Hiveメタストアへの接続失敗時はHiveClient側でリトライが行われる。

## トランザクション仕様

Hiveメタストアはトランザクショナルなメタデータ操作を提供する。テーブル操作はHiveメタストア側のトランザクション制御に依存する。

## パフォーマンス要件

- メタデータのキャッシュによるメタストアアクセス削減
- HiveテーブルのSparkネイティブフォーマット（Parquet/ORC）への変換による高速読み取り
- パーティション刈り込みによる不要パーティションのスキップ

## セキュリティ考慮事項

- Kerberos認証によるHiveメタストアへのセキュアアクセス
- Hiveメタストアの認可機構との連携
- 接続情報のセキュアな管理

## 備考

- SparkSession.builder.enableHiveSupport()でHive連携を有効化
- Hive互換モードにより既存のHiveQLクエリの大部分が実行可能

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ExternalCatalogインターフェース定義 |
| 1-2 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | CatalogTable, CatalogDatabase等のデータ構造 |

**読解のコツ**: CatalogTableはテーブルのメタデータを表現する中核データ構造。identifier, tableType, storage, schema, provider等のフィールドを理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HiveExternalCatalog.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveExternalCatalog.scala` | ExternalCatalog実装、Hiveメタストアとの橋渡し |

**主要処理フロー**:
1. **59-60行目**: HiveExternalCatalogクラス定義、ExternalCatalog継承
2. **69-71行目**: lazy val client - HiveClient初期化（HiveUtils.newClientForMetadata使用）
3. **74-77行目**: clientExceptions - ラップ対象のHive例外定義

#### Step 3: メタストアCatalogを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HiveMetastoreCatalog.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveMetastoreCatalog.scala` | HiveテーブルのSparkプラン変換 |
| 3-2 | HiveSessionCatalog.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveSessionCatalog.scala` | セッションスコープカタログ |
| 3-3 | HiveSessionStateBuilder.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveSessionStateBuilder.scala` | Hiveセッション状態ビルダー |

#### Step 4: Hive固有機能を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HiveInspectors.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveInspectors.scala` | Hive型↔Spark型変換 |
| 4-2 | HiveStrategies.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveStrategies.scala` | Hiveテーブル操作の物理プラン生成 |
| 4-3 | hiveUDFs.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/hiveUDFs.scala` | Hive UDF/UDAF/UDTFサポート |
| 4-4 | HiveUtils.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveUtils.scala` | Hive関連ユーティリティ |

### プログラム呼び出し階層図

```
SparkSession.enableHiveSupport()
    │
    ├─ HiveSessionStateBuilder
    │      ├─ HiveSessionCatalog
    │      │      └─ HiveMetastoreCatalog
    │      │
    │      └─ HiveStrategies
    │
    ├─ HiveExternalCatalog
    │      ├─ HiveClient (lazy)
    │      │      └─ Hive Metastore Thrift API
    │      │
    │      ├─ createTable() / dropTable() / alterTable()
    │      ├─ getTable() / listTables() / tableExists()
    │      └─ createPartitions() / dropPartitions()
    │
    └─ HiveInspectors (型変換)
           └─ Hive ObjectInspector ←→ Spark DataType
```

### データフロー図

```
[入力]                    [処理]                              [出力]

SQL/DataFrame操作 ──▶ HiveSessionCatalog ────▶ CatalogTable
                          │
                          ▼
                    HiveExternalCatalog
                          │
                          ▼
                    HiveClient
                          │
                          ▼
                    Hive Metastore ───────────▶ メタデータ取得/更新
                    (Thrift API)

Hiveテーブル ────▶ HiveMetastoreCatalog ────▶ SparkPlan
                          │
                          ├─ Parquet/ORC変換
                          └─ HiveSerDe使用
                                                   │
                                                   ▼
                                             DataFrame
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HiveExternalCatalog.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveExternalCatalog.scala` | ソース | Hiveメタストア連携ExternalCatalog実装 |
| HiveMetastoreCatalog.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveMetastoreCatalog.scala` | ソース | HiveテーブルのSparkプラン変換 |
| HiveSessionCatalog.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveSessionCatalog.scala` | ソース | セッションスコープカタログ |
| HiveSessionStateBuilder.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveSessionStateBuilder.scala` | ソース | Hiveセッション状態ビルダー |
| HiveInspectors.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveInspectors.scala` | ソース | 型変換 |
| HiveStrategies.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveStrategies.scala` | ソース | 物理プラン生成 |
| HiveUtils.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveUtils.scala` | ソース | ユーティリティ |
| hiveUDFs.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/hiveUDFs.scala` | ソース | Hive UDFサポート |
| HiveShim.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveShim.scala` | ソース | Hiveバージョン互換 |
| TableReader.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/TableReader.scala` | ソース | Hiveテーブル読み取り |
| HiveTableRelationResolver.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveTableRelationResolver.scala` | ソース | Hiveテーブルリレーション解決 |
| HiveContext.scala | `sql/hive/src/main/scala/org/apache/spark/sql/hive/HiveContext.scala` | ソース | Hiveコンテキスト（レガシー） |
