# 機能設計書 30-カタログ管理

## 概要

本ドキュメントは、Apache Sparkにおけるテーブル、ビュー、関数などのメタデータをカタログとして管理する機能の設計について記述する。マルチカタログ対応のメタデータ操作を提供する。

### 本機能の処理概要

Sparkのカタログ管理機能は、SessionCatalogを中核として、データベース、テーブル、ビュー、関数、パーティション等のメタデータを統合的に管理する。ExternalCatalog（InMemoryCatalog、HiveExternalCatalog等）をバックエンドとし、一時ビュー、グローバル一時ビュー、組み込み関数の管理もSessionCatalogが担当する。CatalogManagerにより、Spark 3.0以降はマルチカタログ対応が実現されている。

**業務上の目的・背景**：構造化データ処理において、テーブルやビューのメタデータを一元管理することは不可欠である。Sparkのカタログ管理は、ユーザーがSQLやDataFrame APIを通じてテーブルを作成・参照・削除する際のメタデータのライフサイクルを管理する。マルチカタログ対応により、異なるデータソース（Hive、JDBC、カスタムカタログ等）のテーブルを統一的に扱える。

**機能の利用シーン**：テーブル/ビューの作成・削除・参照、関数の登録・管理、一時ビューの管理、データベースの作成・切り替え、カタログメタデータのブラウジング。

**主要な処理内容**：
1. SessionCatalogによるセッションスコープのメタデータ管理
2. ExternalCatalog（InMemoryCatalog/HiveExternalCatalog）による永続メタデータ管理
3. GlobalTempViewManagerによるグローバル一時ビュー管理
4. FunctionRegistryによる組み込み関数・UDF管理
5. CatalogManagerによるマルチカタログ管理
6. VariableManagerによるセッション変数管理
7. SQLFunctionによるSQL定義関数管理

**関連システム・外部連携**：Hiveメタストア（HiveExternalCatalog経由）、CatalogPlugin（V2カタログ拡張）、FunctionRegistry（関数管理）

**権限による制御**：カタログ操作に対するACLはExternalCatalog実装（特にHiveExternalCatalog）で管理される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 直接関連する専用画面なし（SQL実行画面でDDL操作が表示される） |

## 機能種別

メタデータ管理 / CRUD操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| databaseName | String | Yes | データベース名 | 有効な識別子 |
| tableName | TableIdentifier | Yes | テーブル識別子 | データベース名.テーブル名形式 |
| viewDefinition | String | No | ビュー定義SQL | 有効なSQL文 |
| functionName | String | No | 関数名 | 有効な識別子 |
| catalogName | String | No | カタログ名 | 登録済みカタログ名 |

### 入力データソース

- ExternalCatalog（InMemoryCatalog / HiveExternalCatalog）
- CatalogPlugin（V2カタログ）
- メモリ内の一時メタデータ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| CatalogTable | CatalogTable | テーブルメタデータ |
| CatalogDatabase | CatalogDatabase | データベースメタデータ |
| CatalogFunction | CatalogFunction | 関数メタデータ |
| LogicalPlan | LogicalPlan | ビュー/一時ビューの論理計画 |

### 出力先

- ExternalCatalog（永続メタデータの格納）
- メモリ（一時ビュー、関数定義）
- CatalogPlugin（V2カタログへのメタデータ操作）

## 処理フロー

### 処理シーケンス

```
1. SessionCatalog初期化
   └─ ExternalCatalog、GlobalTempViewManager、FunctionRegistry等の初期化
2. データベース操作
   └─ createDatabase / dropDatabase / setCurrentDatabase
3. テーブル操作
   └─ createTable / dropTable / renameTable / alterTable
4. ビュー操作
   └─ createTempView / createGlobalTempView / dropTempView
5. 関数操作
   └─ registerFunction / lookupFunction / dropFunction
6. パーティション操作
   └─ createPartitions / dropPartitions / listPartitions
7. キャッシュ管理
   └─ テーブルメタデータのキャッシュと無効化
```

### フローチャート

```mermaid
flowchart TD
    A[SQL DDL / Catalog API] --> B[SessionCatalog]
    B --> C{操作対象}
    C -->|永続テーブル| D[ExternalCatalog]
    C -->|一時ビュー| E[tempViews Map]
    C -->|グローバル一時ビュー| F[GlobalTempViewManager]
    C -->|関数| G[FunctionRegistry]
    C -->|V2カタログ| H[CatalogManager]
    D --> I{バックエンド}
    I -->|InMemory| J[InMemoryCatalog]
    I -->|Hive| K[HiveExternalCatalog]
    H --> L[CatalogPlugin]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-30-01 | デフォルトデータベース | セッション開始時のデフォルトデータベースは"default" | セッション初期化時 |
| BR-30-02 | スレッドセーフ | SessionCatalogはスレッドセーフでなければならない | 全操作 |
| BR-30-03 | 一時ビュー優先 | 同名のテーブルと一時ビューがある場合、一時ビューが優先 | テーブル参照時 |
| BR-30-04 | グローバル一時ビュー | グローバル一時ビューは特別なデータベース（global_temp）に格納 | グローバル一時ビュー操作時 |
| BR-30-05 | 関数キャッシュ | lookupされた関数はGuava Cacheでキャッシュされる | 関数参照時 |

### 計算ロジック

SessionCatalogはテーブル/ビュー解決時に以下の順序で検索する:
1. 一時ビュー（セッションスコープ）
2. グローバル一時ビュー（global_tempデータベース）
3. ExternalCatalog（永続テーブル）

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| createDatabase | ExternalCatalog | CREATE | データベースメタデータの作成 |
| createTable | ExternalCatalog | CREATE | テーブルメタデータの作成 |
| dropTable | ExternalCatalog | DELETE | テーブルメタデータの削除 |
| alterTable | ExternalCatalog | UPDATE | テーブルメタデータの変更 |
| createTempView | メモリ | CREATE | 一時ビューの登録 |
| registerFunction | FunctionRegistry | CREATE | 関数の登録 |

### テーブル別操作詳細

#### SessionCatalog内部ストア

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| CREATE TABLE | CatalogTable全体 | ExternalCatalogに委譲 | formatDatabaseName処理あり |
| CREATE TEMP VIEW | LogicalPlan | tempViewsマップに格納 | セッションスコープ |
| REGISTER FUNCTION | FunctionBuilder | FunctionRegistryに登録 | キャッシュあり |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| DATABASE_NOT_FOUND | 未検出エラー | データベースが存在しない | データベース名の確認 |
| TABLE_ALREADY_EXISTS | 重複エラー | テーブル名の重複 | IF NOT EXISTS使用 |
| TABLE_OR_VIEW_NOT_FOUND | 未検出エラー | テーブル/ビューが存在しない | 名前の確認 |
| FUNCTION_NOT_FOUND | 未検出エラー | 関数が存在しない | 関数名の確認 |
| REQUIRES_SINGLE_PART_NAMESPACE | 名前空間エラー | マルチパート名前空間の非サポート | 名前空間構造の確認 |

### リトライ仕様

カタログ操作自体にリトライ機構はない。ExternalCatalog実装がリトライを提供する場合がある。

## トランザクション仕様

SessionCatalog自体にはトランザクション機構はない。ExternalCatalog実装（HiveExternalCatalog等）が提供するトランザクション機構に依存する。一時ビュー/関数の操作はメモリ内のアトミックな操作として実行される。

## パフォーマンス要件

- Guava Cacheによる関数/テーブルメタデータのキャッシュ
- 大量テーブルの一覧取得時のパフォーマンス（listTables）
- グローバル一時ビューのクロスセッションアクセス性能

## セキュリティ考慮事項

- ExternalCatalog実装によるメタデータアクセス制御
- 一時ビューはセッションスコープで他セッションからアクセス不可
- グローバル一時ビューは全セッションからアクセス可能なため注意が必要

## 備考

- SessionCatalogのDEFAULT_DATABASEは"default"
- CatalogManagerのSESSION_CATALOG_NAMEは"spark_catalog"

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | CatalogTable, CatalogDatabase, CatalogFunction等のデータ構造 |
| 1-2 | ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | 永続メタデータストアのインターフェース |

**読解のコツ**: interface.scalaのCatalogTableがメタデータの中核データ構造。CatalogTableType（MANAGED/EXTERNAL/VIEW）、CatalogStorageFormat等のネストした構造を理解する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SessionCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/SessionCatalog.scala` | セッションスコープのカタログ管理本体 |

**主要処理フロー**:
1. **61-63行目**: SessionCatalog objectのDEFAULT_DATABASE = "default"
2. **72-80行目**: SessionCatalogクラス定義、externalCatalogBuilder/globalTempViewManagerBuilder/functionRegistry/tableFunctionRegistry等のコンストラクタパラメータ
3. クラスの@GuardedByアノテーションによるスレッドセーフ設計

#### Step 3: ExternalCatalog実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | InMemoryCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/InMemoryCatalog.scala` | テスト/開発用インメモリカタログ |
| 3-2 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | イベントリスナー付きカタログラッパー |

#### Step 4: グローバル一時ビューと関数管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | GlobalTempViewManager.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/GlobalTempViewManager.scala` | グローバル一時ビュー管理 |
| 4-2 | FunctionRegistry | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/analysis/FunctionRegistry.scala` | 関数レジストリ |
| 4-3 | VariableManager.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/VariableManager.scala` | セッション変数管理 |
| 4-4 | SQLFunction.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/SQLFunction.scala` | SQL定義関数 |

### プログラム呼び出し階層図

```
SessionCatalog
    │
    ├─ ExternalCatalog (永続メタデータ)
    │      ├─ InMemoryCatalog
    │      ├─ HiveExternalCatalog
    │      └─ ExternalCatalogWithListener (イベント通知)
    │
    ├─ GlobalTempViewManager (グローバル一時ビュー)
    │      └─ global_tempデータベース
    │
    ├─ FunctionRegistry (組み込み/UDF関数)
    │      ├─ SimpleFunctionRegistry
    │      └─ V1Function
    │
    ├─ TableFunctionRegistry (テーブル関数)
    │
    ├─ VariableManager (セッション変数)
    │
    └─ CatalogManager (マルチカタログ)
           ├─ SESSION_CATALOG_NAME ("spark_catalog")
           └─ CatalogPlugin (V2カタログ)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

DDL文 ──────────────▶ SessionCatalog ──────────▶ ExternalCatalog
(CREATE/DROP/ALTER)       │                          │
                          ├─ tempViews管理           ├─ InMemoryCatalog
                          ├─ globalTempViews管理     └─ HiveExternalCatalog
                          └─ functionRegistry管理

テーブル参照 ────────▶ SessionCatalog ──────────▶ CatalogTable / LogicalPlan
(SELECT FROM)             │
                          ├─ 1. tempViews検索
                          ├─ 2. globalTempViews検索
                          └─ 3. ExternalCatalog検索
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SessionCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/SessionCatalog.scala` | ソース | セッションスコープカタログ管理本体 |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 永続メタデータストアインターフェース |
| InMemoryCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/InMemoryCatalog.scala` | ソース | インメモリカタログ実装 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベントリスナー付きラッパー |
| GlobalTempViewManager.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/GlobalTempViewManager.scala` | ソース | グローバル一時ビュー管理 |
| ExternalCatalogUtils.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogUtils.scala` | ソース | カタログユーティリティ |
| interface.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/interface.scala` | ソース | カタログデータ構造定義 |
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | カタログイベント定義 |
| functionResources.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/functionResources.scala` | ソース | 関数リソース管理 |
| SQLFunction.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/SQLFunction.scala` | ソース | SQL定義関数 |
| VariableManager.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/VariableManager.scala` | ソース | 変数管理 |
| UserDefinedFunction.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/UserDefinedFunction.scala` | ソース | UDF定義 |
| SqlScriptingContextManager.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/SqlScriptingContextManager.scala` | ソース | SQLスクリプティング管理 |
