# 機能設計書 43-ロジスティック回帰

## 概要

本ドキュメントは、Apache Spark MLlibにおけるロジスティック回帰（Logistic Regression）機能の設計を記述する。二値および多クラス分類のためのロジスティック回帰モデルの訓練と予測を提供する。

### 本機能の処理概要

ロジスティック回帰は、確率的分類アルゴリズムを提供する機能であり、入力特徴量から各クラスに属する確率を推定し、分類結果を出力する。

**業務上の目的・背景**：分類問題は機械学習の中で最も一般的なタスクの一つであり、スパム検出、不正検知、医療診断等の幅広い業務で使用される。ロジスティック回帰は解釈性が高く、大規模データに対しても効率的に学習できるため、分類タスクのベースラインモデルとして広く採用されている。

**機能の利用シーン**：二値分類（スパム/非スパム）、多クラス分類（カテゴリ分類）、確率推定が必要な場面で使用される。L1/L2正則化やElastic Net正則化をサポートし、過学習を防止する。

**主要な処理内容**：
1. 入力データの前処理（標準化、ブロック化）
2. LBFGS/OWLQN/LBFGSB最適化アルゴリズムによるモデルパラメータ推定
3. 二値分類（binomial）および多クラス分類（multinomial）のサポート
4. 係数・切片の境界制約付き最適化のサポート
5. 予測確率と分類結果の出力

**関連システム・外部連携**：Pipeline API、CrossValidator/TrainValidationSplit、特徴量変換器と連携する。

**権限による制御**：特段のロール制御はない。

## 関連画面

本機能に直接関連する画面はない。

## 機能種別

計算処理 / 機械学習分類

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| featuresCol | String | Yes | 特徴量カラム名 | データセットに存在するVector型カラム |
| labelCol | String | Yes | ラベルカラム名 | 0以上の整数値 |
| weightCol | String | No | 重みカラム名 | 非負の数値 |
| regParam | Double | No | 正則化パラメータ、デフォルト0.0 | 0以上 |
| elasticNetParam | Double | No | ElasticNet混合パラメータ、デフォルト0.0 | [0, 1] |
| maxIter | Int | No | 最大反復回数、デフォルト100 | 正の整数 |
| tol | Double | No | 収束許容誤差、デフォルト1E-6 | 正の値 |
| fitIntercept | Boolean | No | 切片項のフィット有無、デフォルトtrue | - |
| family | String | No | "auto"/"binomial"/"multinomial"、デフォルト"auto" | サポートされた値 |
| standardization | Boolean | No | 特徴量の標準化有無、デフォルトtrue | - |
| threshold | Double | No | 二値分類の閾値、デフォルト0.5 | [0, 1] |
| aggregationDepth | Int | No | treeAggregate深度、デフォルト2 | 2以上 |
| maxBlockSizeInMB | Double | No | ブロックサイズ、デフォルト0.0（自動1.0MB） | 0以上 |

### 入力データソース

MLlibのDataFrame/Datasetとして提供されるラベル付きトレーニングデータ。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| LogisticRegressionModel | LogisticRegressionModel | 学習済みモデル（係数行列・切片ベクトルを含む） |
| prediction | Double | 予測クラスラベル |
| rawPrediction | Vector | 各クラスのraw予測値 |
| probability | Vector | 各クラスの予測確率 |

### 出力先

メモリ内のLogisticRegressionModelオブジェクト、またはMLWriter経由でファイルシステムに永続化。

## 処理フロー

### 処理シーケンス

```
1. データ検証
   └─ ラベルの有効性チェック（非負整数）
   └─ 特徴量のNaNチェック
   └─ 重みの非負チェック

2. データ前処理
   └─ 特徴量の統計量計算（平均・標準偏差）
   └─ 特徴量の標準化（standardization=trueの場合）
   └─ インスタンスのブロック化（maxBlockSizeInMB設定時）

3. 最適化実行
   └─ familyに基づくモデル選択（binomial/multinomial）
   └─ 正則化の設定（L1/L2/ElasticNet）
   └─ 境界制約の設定（設定時）
   └─ LBFGS/OWLQN/LBFGSB最適化の実行

4. モデル生成
   └─ 最適化結果から係数行列と切片ベクトルを抽出
   └─ 標準化の逆変換
   └─ LogisticRegressionModelの構築
```

### フローチャート

```mermaid
flowchart TD
    A[train開始] --> B[データ検証]
    B --> C[特徴量統計量計算]
    C --> D{standardization?}
    D -->|Yes| E[特徴量標準化]
    D -->|No| F[そのまま]
    E --> G{family判定}
    F --> G
    G -->|binomial| H[二値分類最適化]
    G -->|multinomial| I[多クラス分類最適化]
    H --> J{境界制約あり?}
    I --> J
    J -->|Yes| K[LBFGSB最適化]
    J -->|No| L{ElasticNet > 0?}
    L -->|Yes| M[OWLQN最適化]
    L -->|No| N[LBFGS最適化]
    K --> O[係数抽出・逆標準化]
    M --> O
    N --> O
    O --> P[LogisticRegressionModel生成]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-43-01 | family自動判定 | numClasses <= 2の場合はbinomial、それ以外はmultinomial | family="auto"の場合 |
| BR-43-02 | 閾値整合性 | thresholdとthresholdsが両方設定された場合は等価であることを検証 | 両方が設定時 |
| BR-43-03 | 境界制約とElasticNet | 境界制約付き最適化ではelasticNetParam=0.0のみサポート | 境界制約設定時 |
| BR-43-04 | 正則化パラメータ | alpha=0でL2、alpha=1でL1、0<alpha<1でElasticNet | 正則化使用時 |

### 計算ロジック

- 二値ロジスティック回帰: `P(y=1|x) = 1 / (1 + exp(-(w^T x + b)))`
- 多クラスロジスティック回帰（ソフトマックス）: `P(y=k|x) = exp(w_k^T x + b_k) / sum_j(exp(w_j^T x + b_j))`
- 損失関数: クロスエントロピー損失 + 正則化項

## データベース操作仕様

本機能はデータベースへの直接操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| IllegalArgumentException | バリデーションエラー | thresholdとthresholdsが不整合 | 一方のみ設定する |
| IllegalArgumentException | バリデーションエラー | 境界制約の形状が不正 | 正しい形状の行列/ベクトルを設定 |
| SparkException | 計算エラー | 最適化が収束しない | maxIterを増やすかtolを緩める |

### リトライ仕様

特になし。最適化の反復は`maxIter`パラメータで制御される。

## トランザクション仕様

該当なし。

## パフォーマンス要件

- ブロック化によるGEMV/GEMM最適化で大規模データの処理性能を向上
- treeAggregateによる分散集約で通信オーバーヘッドを削減

## セキュリティ考慮事項

モデル永続化時のアクセス制御を適用する必要がある。

## 備考

- Spark 3.1.0以降、インスタンスのブロックスタッキングとGEMV/GEMMによる性能最適化をサポート
- 境界制約付き最適化はLBFGSBオプティマイザを使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | LogisticRegression.scala | `mllib/src/main/scala/org/apache/spark/ml/classification/LogisticRegression.scala` | LogisticRegressionParamsトレイト（54-282行目）でパラメータ定義、特にfamily/threshold/thresholds/境界制約パラメータを理解する |

**読解のコツ**: `HasRegParam`、`HasElasticNetParam`等の共有パラメータトレイトをミックスインしている。`checkThresholdConsistency()`でthresholdとthresholdsの整合性を検証する仕組みを理解することが重要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | LogisticRegression.scala | `mllib/src/main/scala/org/apache/spark/ml/classification/LogisticRegression.scala` | LogisticRegressionクラス（296-500行目）のtrain()メソッドを理解する |

**主要処理フロー**:
1. **297-300行目**: クラス定義、ProbabilisticClassifierを継承
2. **258-260行目**: デフォルトパラメータ設定
3. **312行目**: `setRegParam` - 正則化パラメータ設定
4. **453-496行目**: `assertBoundConstrainedOptimizationParamsValid` - 境界制約パラメータ検証

#### Step 3: 最適化アルゴリズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LogisticRegression.scala | `mllib/src/main/scala/org/apache/spark/ml/classification/LogisticRegression.scala` | train()内の最適化ロジック - LBFGS/OWLQN/LBFGSB分岐を理解する |

### プログラム呼び出し階層図

```
LogisticRegression.train(dataset)
    |
    +-- データ検証・前処理
    |       +-- checkClassificationLabels()
    |       +-- Summarizer（特徴量統計量計算）
    |
    +-- 最適化器選択
    |       +-- LBFGS（L2正則化のみ、境界制約なし）
    |       +-- OWLQN（L1/ElasticNet正則化）
    |       +-- LBFGSB（境界制約付き最適化）
    |
    +-- RDDLossFunction（損失関数）
    |       +-- LogisticAggregator（集約計算）
    |       +-- L2Regularization（正則化項）
    |
    +-- LogisticRegressionModel生成
            +-- 係数行列・切片ベクトル設定
```

### データフロー図

```
[入力]                  [処理]                          [出力]

Dataset ──────> 特徴量統計量計算
(label,          |
 features,       v
 weight)    標準化(オプション)
                 |
                 v
            ブロック化(オプション)
                 |
                 v
            LBFGS/OWLQN/LBFGSB ──> 最適化結果
            最適化                    (係数ベクトル)
                 |
                 v
            逆標準化 ──────────> LogisticRegressionModel
                                    |
                                    v
                               predict(features)
                                    |
                                    v
                               (prediction, rawPrediction, probability)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| LogisticRegression.scala | `mllib/src/main/scala/org/apache/spark/ml/classification/LogisticRegression.scala` | ソース | ロジスティック回帰の全実装 |
| ProbabilisticClassifier.scala | `mllib/src/main/scala/org/apache/spark/ml/classification/ProbabilisticClassifier.scala` | ソース | 確率的分類器の基底クラス |
| LogisticAggregator.scala | `mllib/src/main/scala/org/apache/spark/ml/optim/aggregator/LogisticAggregator.scala` | ソース | ロジスティック損失の集約計算 |
| RDDLossFunction.scala | `mllib/src/main/scala/org/apache/spark/ml/optim/loss/RDDLossFunction.scala` | ソース | 分散損失関数 |
