# 機能設計書 55-勾配ブースティング木回帰

## 概要

本ドキュメントは、Apache Spark MLlibが提供する勾配ブースティング木回帰（GBTRegressor）機能の設計を記述する。本機能は、Gradient-Boosted Trees（GBT）アルゴリズムに基づく回帰モデルの訓練と予測を提供する。

### 本機能の処理概要

GBT回帰は、損失関数の勾配方向に新しい決定木を順次追加していくブースティング手法である。各ステップで残差を学習する木を追加し、重み付き加算により最終予測を行う。

**業務上の目的・背景**：ランダムフォレストが「バギング」によるアンサンブルであるのに対し、GBTは「ブースティング」により逐次的に弱学習器を改善する。一般にGBTはランダムフォレストよりも高い予測精度を達成できるが、過学習のリスクがあるため適切なハイパーパラメータチューニングが必要。

**機能の利用シーン**：高精度予測が最優先の回帰タスク、コンペティション向けモデリング、特徴量の重要度分析に利用される。

**主要な処理内容**：
1. 検証データセットによる早期停止（Early Stopping）対応
2. 損失関数（squared, absolute）の選択
3. 逐次的な決定木の追加と重み計算
4. 各イテレーションの損失評価（evaluateEachIteration）

**関連システム・外部連携**：GradientBoostedTrees実装、EnsembleModelReadWriteによる永続化。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 本機能に直接関連する画面はなし |

## 機能種別

計算処理（機械学習 - 勾配ブースティング回帰）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| maxIter | Int | No | 最大反復回数/木の数（デフォルト: 20） | >= 1 |
| stepSize | Double | No | 学習率（デフォルト: 0.1） | (0, 1] |
| lossType | String | No | 損失関数（デフォルト: "squared"） | "squared", "absolute" |
| subsamplingRate | Double | No | サブサンプリング率（デフォルト: 1.0） | (0, 1] |
| maxDepth | Int | No | 木の最大深度（デフォルト: 5） | >= 0 |
| maxBins | Int | No | 分割ビン数（デフォルト: 32） | >= 2 |
| featureSubsetStrategy | String | No | 特徴量サブセット戦略（デフォルト: "all"） | - |
| validationIndicatorCol | String | No | 検証データフラグ列名 | - |
| validationTol | Double | No | 検証損失の許容劣化率 | - |
| seed | Long | No | ランダムシード | - |
| weightCol | String | No | 重み列名 | - |

### 入力データソース

DataFrame形式。ラベル列はDouble型、特徴量列はVector型。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| prediction | Double | 全木の重み付き予測合計 |
| leaf | Vector | 各木のリーフノードインデックス（leafCol設定時） |

### 出力先

入力DataFrameに予測列を追加。モデルはEnsembleModelReadWrite形式で永続化。

## 処理フロー

### 処理シーケンス

```
1. 検証データセット分割（validationIndicatorCol設定時）
2. 訓練・検証インスタンスの抽出
3. ブースティング戦略の生成
4. GradientBoostedTrees.run/runWithValidation
5. GBTRegressionModel生成
```

### フローチャート

```mermaid
flowchart TD
    A[開始: train] --> B{validationIndicatorCol設定?}
    B -->|Yes| C[訓練/検証データ分割]
    B -->|No| D[全データを訓練用に使用]
    C --> E[GradientBoostedTrees.runWithValidation]
    D --> F[GradientBoostedTrees.run]
    E --> G[baseLearners + learnerWeights取得]
    F --> G
    G --> H[GBTRegressionModel生成]
    H --> I[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-55-01 | 不純度設定無視 | GBTRegressorではImpurityの設定は無視され、常にVarianceが使用される | 常時 |
| BR-55-02 | 最小モデル数 | 1つ以上の決定木が必要 | 常時 |
| BR-55-03 | 木数と重み数の一致 | 木の配列と重みの配列は同じ長さでなければならない | 常時 |
| BR-55-04 | 予測ルール | 全木の予測値と重みの内積（BLAS.ddot）を出力 | 予測時 |

### 計算ロジック

- 予測: `BLAS.nativeBLAS.ddot(numTrees, treePredictions, 1, treeWeights, 1)`
- 特徴量重要度: TreeEnsembleModel.featureImportances（perTreeNormalization=false）
- 検証損失: GradientBoostedTrees.evaluateEachIteration

## データベース操作仕様

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RequireError | 木の配列が空 | maxIter >= 1を設定 |
| - | RequireError | 木と重みの配列長が不一致 | 内部エラー（通常発生しない） |

### リトライ仕様

特になし。

## トランザクション仕様

Sparkの遅延評価に基づく。

## パフォーマンス要件

- 逐次学習のため、木の数に比例して訓練時間が増加
- 検証データセットによる早期停止で不要な訓練を回避可能

## セキュリティ考慮事項

Sparkの標準セキュリティ機構に従う。

## 備考

- Spark 1.4.0で導入
- J.H. Friedman "Stochastic Gradient Boosting" (1999)に基づく実装
- Stochastic Gradient Boostingの実装であり、TreeBoostではない
- evaluateEachIterationメソッドで各イテレーションの検証損失を取得可能

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GBTRegressor.scala | `mllib/src/main/scala/org/apache/spark/ml/regression/GBTRegressor.scala` | GBTRegressorParams の継承構造（lossType, validationTol等の特有パラメータ） |
| 1-2 | GBTRegressor.scala | 同上 | GBTRegressionModel（222-354行目）のtreesとtreeWeightsの関係 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | GBTRegressor.scala | 同上 | train()（167-198行目） |

**主要処理フロー**:
1. **168行目**: validationIndicatorColの有無で分岐
2. **169-174行目**: 検証データの分割（withValidation=true時）
3. **184-191行目**: GradientBoostedTrees.run/runWithValidation呼出し
4. **197行目**: GBTRegressionModel生成

**読解のコツ**: setImpurity（115-118行目）は警告を出して何もしない点に注目。GBTでは不純度は常にVariance。

#### Step 3: 予測処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | GBTRegressor.scala | 同上 | predict()（302-306行目）でBLAS.ddotによる重み付き合計 |

#### Step 4: 評価処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | GBTRegressor.scala | 同上 | evaluateEachIteration()（346-350行目）で各ステップの損失を計算 |

### プログラム呼び出し階層図

```
GBTRegressor.train(dataset)
    |
    +-- extractInstances(this, dataset)
    +-- MetadataUtils.getCategoricalFeatures()
    +-- getOldBoostingStrategy()
    |
    +-- [分岐: 検証データ有無]
    |   +-- GradientBoostedTrees.runWithValidation(train, valid, strategy)
    |   +-- GradientBoostedTrees.run(train, strategy)
    |
    +-- new GBTRegressionModel(uid, baseLearners, learnerWeights, numFeatures)

GBTRegressionModel.predict(features)
    |
    +-- trees.map(_.rootNode.predictImpl(features).prediction)
    +-- BLAS.nativeBLAS.ddot(numTrees, predictions, 1, weights, 1)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

DataFrame          train()
  (label,          +-- 検証データ分割（オプション）    GBTRegressionModel
   features,       +-- 逐次的にN本の木を訓練              (trees[N],
   weight,         +-- 各ステップで残差を学習               treeWeights[N])
   validFlag)

DataFrame          predict()
  (features)       +-- 全木のprediction取得           DataFrame
                   +-- 重み付き合計 (ddot)              (prediction,
                                                         leaf)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| GBTRegressor.scala | `mllib/src/main/scala/org/apache/spark/ml/regression/GBTRegressor.scala` | ソース | Estimator/Model の実装 |
| GradientBoostedTrees.scala | `mllib/src/main/scala/org/apache/spark/ml/tree/impl/GradientBoostedTrees.scala` | ソース | ブースティングアルゴリズム |
| DecisionTreeRegressor.scala | `mllib/src/main/scala/org/apache/spark/ml/regression/DecisionTreeRegressor.scala` | ソース | 基盤学習器（個々の決定木） |
| EnsembleModelReadWrite.scala | `mllib/src/main/scala/org/apache/spark/ml/tree/EnsembleModelReadWrite.scala` | ソース | アンサンブルモデルの永続化 |
