# 機能設計書 84-Standaloneクラスタマネージャ

## 概要

本ドキュメントは、Spark独自のスタンドアロンクラスタマネージャの機能設計を記述する。MasterとWorkerによるリソース管理を行う。

### 本機能の処理概要

Standaloneクラスタマネージャは、Sparkに組み込まれた独自のクラスタマネージャであり、外部のリソース管理システム（YARN、Kubernetes等）を必要とせずにSparkクラスタを運用できる。Masterノードがクラスタ全体のリソース管理とアプリケーションスケジューリングを行い、Workerノードが各ノード上のExecutorプロセスの起動・監視を担当する。

**業務上の目的・背景**：外部のクラスタマネージャを導入・運用するオーバーヘッドなしにSparkクラスタを構築できるようにする。小規模〜中規模のクラスタ環境や、開発・テスト環境での迅速なクラスタ構築を可能にする。フォールトトレランスとしてZooKeeperベースのMasterリカバリもサポートする。

**機能の利用シーン**：専用Sparkクラスタの構築と運用、開発・テスト環境の構築、外部依存を最小化したSparkデプロイメント、マルチアプリケーション実行環境の管理。

**主要な処理内容**：
1. Master起動：RPCエンドポイントとWebUI、REST APIサーバーの起動
2. Worker登録：Workerからの登録要求を受け付け、リソース情報を管理
3. アプリケーション登録：ドライバーからのアプリケーション登録とExecutor割り当て
4. リソーススケジューリング：ワーカー選択ポリシーに基づくExecutorの配置最適化
5. フォールトトレランス：Masterの障害復旧（ZooKeeper）、Workerの死活監視
6. ドライバー管理：clusterモードでのドライバープロセスの起動・監視

**関連システム・外部連携**：ZooKeeper（Master HA）、MetricsSystem（モニタリング）、Web UI（管理画面）、REST API

**権限による制御**：SecurityManagerによるACL制御、Web UIへのアクセス制御

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 24 | Master Overview（マスター概要） | 主機能 | MasterEndpointからワーカー・アプリケーション・ドライバー情報を取得表示 |
| 25 | Application Detail（アプリケーション詳細） | 主機能 | MasterEndpointからアプリケーションのExecutor割り当て情報を取得表示 |
| 26 | Master Log（マスターログ） | 補助機能 | マスタープロセスのログファイル表示 |
| 27 | Master Environment（マスター環境情報） | 補助機能 | マスターの環境変数・リソース設定を表示 |
| 28 | Worker Overview（ワーカー概要） | 主機能 | WorkerEndpointからワーカーのリソース・Executor情報を表示 |
| 29 | Worker Log（ワーカーログ） | 補助機能 | ワーカーのExecutor/ドライバーログを表示 |

## 機能種別

クラスタ管理 / リソーススケジューリング

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| spark.master | String | Yes | MasterのURL（spark://host:port） | spark://形式 |
| spark.deploy.recoveryMode | String | No | リカバリモード（NONE/ZOOKEEPER/FILESYSTEM） | 列挙値 |
| spark.worker.timeout | Long | No | Workerタイムアウト（秒） | 正の整数 |
| spark.deploy.retainedApplications | Int | No | 保持する完了済みアプリケーション数 | 正の整数 |
| spark.deploy.retainedDrivers | Int | No | 保持する完了済みドライバー数 | 正の整数 |
| spark.deploy.maxDrivers | Int | No | 最大ドライバー数 | 正の整数 |

### 入力データソース

RPCメッセージ（Worker登録、アプリケーション登録、ドライバー登録）、spark-defaults.conf

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Executor割り当て | ExecutorDescription | Executor起動指示（Worker、コア数、メモリ等） |
| アプリケーション状態 | ApplicationInfo | アプリケーションの実行状態・メトリクス |
| ワーカー状態 | WorkerInfo | ワーカーの利用可能リソース・状態 |

### 出力先

各Workerノード（RPCメッセージ）、Web UI（HTTP）、REST API

## 処理フロー

### 処理シーケンス

```
1. Master起動
   └─ RpcEnv/RPCエンドポイント起動、WebUI起動、RESTサーバー起動
2. Worker登録
   └─ RegisterWorker メッセージ受信、WorkerInfoに登録
3. アプリケーション登録
   └─ RegisterApplication メッセージ受信、ApplicationInfoに登録
4. リソーススケジューリング
   └─ schedule()で待機中アプリケーションにExecutorを割り当て
5. Executor起動指示
   └─ Worker に LaunchExecutor メッセージ送信
6. ハートビート処理
   └─ Workerからの定期的なHeartbeat受信、タイムアウト検出
7. 障害復旧
   └─ ZooKeeper/FileSystemからの状態復元
```

### フローチャート

```mermaid
flowchart TD
    A[Master起動] --> B[RPC/WebUI/REST起動]
    B --> C{メッセージ受信}
    C -->|RegisterWorker| D[Worker登録]
    C -->|RegisterApplication| E[App登録]
    C -->|Heartbeat| F[ハートビート処理]
    C -->|WorkerTimeout| G[Worker除外]
    D --> H[schedule実行]
    E --> H
    H --> I{待機中App?}
    I -->|Yes| J[Executor割り当て]
    I -->|No| K[待機]
    J --> L[LaunchExecutor送信]
    F --> M{タイムアウト?}
    M -->|Yes| G
    M -->|No| C
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-84-01 | ワーカー選択ポリシー | WorkerSelectionPolicyに基づきExecutor配置先Workerを選択する | schedule()実行時 |
| BR-84-02 | ワーカータイムアウト | workerTimeoutMs以内にハートビートがないWorkerを失効とする | Heartbeat監視ループ |
| BR-84-03 | リカバリモード | ZooKeeperモードではMasterの状態を永続化しフェイルオーバーを実現する | Master起動時 |
| BR-84-04 | アプリ番号管理 | nextAppNumber + moduloAppNumberでアプリケーションIDを生成する | アプリケーション登録時 |

### 計算ロジック

ワーカーリソース配分：各Workerの空きコア数・メモリから、アプリケーションが要求するExecutor仕様（コア数・メモリ）を満たすWorkerを選択する。

## データベース操作仕様

### 操作別データベース影響一覧

本機能は直接的なデータベース操作を行わない。ZooKeeperを使用した状態永続化のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Worker登録失敗 | 同一アドレスのWorkerが既に登録済み | 古い登録を削除して再登録 |
| - | Executor起動失敗 | Worker上でExecutor起動に失敗 | MAX_EXECUTOR_RETRIESまでリトライ |
| - | Master障害 | Masterプロセスが停止 | ZooKeeperによるフェイルオーバー |

### リトライ仕様

Executor起動失敗時は spark.deploy.maxExecutorRetries で設定された回数までリトライする。

## トランザクション仕様

該当なし（RPCベースの状態管理）。

## パフォーマンス要件

- Master起動時間は数秒以内
- ハートビート処理は非同期で実行し、スケジューリングスレッドをブロックしない
- アプリケーション・ドライバー情報はメモリ上のHashMap/HashSetで管理し高速アクセスを実現

## セキュリティ考慮事項

- SecurityManagerによるWebUIへのアクセス制御
- RPC通信の暗号化設定

## 備考

StandaloneクラスタマネージャはSpark付属の軽量クラスタマネージャであり、大規模な本番環境ではYARNやKubernetesの使用が推奨される。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Master/Workerが管理するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Master.scala | `core/src/main/scala/org/apache/spark/deploy/master/Master.scala` | **72-91行目**: workers, idToApp, waitingApps, apps, drivers等の管理データ構造 |
| 1-2 | ApplicationDescription.scala | `core/src/main/scala/org/apache/spark/deploy/ApplicationDescription.scala` | アプリケーション記述のデータクラス |
| 1-3 | DeployMessages.scala | `core/src/main/scala/org/apache/spark/deploy/DeployMessages.scala` | RPCメッセージ型の一覧（RegisterWorker, RegisterApplication等） |

**読解のコツ**: MasterはThreadSafeRpcEndpointを継承しており、receiveメソッドでRPCメッセージを受信してパターンマッチで分岐処理する。

#### Step 2: Masterエントリーポイントを理解する

Masterの起動と主要メッセージ処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Master.scala | `core/src/main/scala/org/apache/spark/deploy/master/Master.scala` | **49-100行目**: Master初期化、メトリクスシステム、設定値の読み込み |

**主要処理フロー**:
1. **57行目**: forwardMessageThread - メッセージ転送用スレッド
2. **60-70行目**: 各種設定値の読み込み（workerTimeoutMs, retainedApplications等）
3. **72-91行目**: データ管理用のHashMap/HashSet/ArrayBuffer初期化

#### Step 3: Workerの構造を理解する

Workerノードの実装を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Worker.scala | `core/src/main/scala/org/apache/spark/deploy/worker/Worker.scala` | **52-80行目**: Workerの初期化、マスターアドレス管理、Decommission対応 |

### プログラム呼び出し階層図

```
Master (RpcEndpoint)
    |
    +-- receive(RegisterWorker)
    |       +-- WorkerInfo管理
    |       +-- schedule()
    |
    +-- receive(RegisterApplication)
    |       +-- ApplicationInfo管理
    |       +-- schedule()
    |               +-- WorkerSelectionPolicy
    |               +-- LaunchExecutor -> Worker
    |
    +-- receive(Heartbeat)
    |       +-- WorkerInfo.lastHeartbeat更新
    |
    +-- MasterWebUI
    +-- StandaloneRestServer

Worker (RpcEndpoint)
    |
    +-- receive(LaunchExecutor)
    |       +-- ExecutorRunner起動
    |
    +-- receive(KillExecutor)
    +-- Heartbeat送信ループ
    +-- WorkerWebUI
```

### データフロー図

```
[入力]                      [処理]                        [出力]

RegisterWorker ────▶ Master.receive() ──▶ WorkerInfo登録
RegisterApplication ▶ Master.receive() ──▶ schedule()
                                              |
                                     Executor割り当て計算
                                              |
                                              v
LaunchExecutor ◀── Master ──▶ Worker ──▶ ExecutorRunner起動
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Master.scala | `core/src/main/scala/org/apache/spark/deploy/master/Master.scala` | ソース | Masterノードの主要ロジック |
| Worker.scala | `core/src/main/scala/org/apache/spark/deploy/worker/Worker.scala` | ソース | Workerノードの主要ロジック |
| DeployMessages.scala | `core/src/main/scala/org/apache/spark/deploy/DeployMessages.scala` | ソース | RPCメッセージ定義 |
| ApplicationDescription.scala | `core/src/main/scala/org/apache/spark/deploy/ApplicationDescription.scala` | ソース | アプリケーション記述 |
| DriverDescription.scala | `core/src/main/scala/org/apache/spark/deploy/DriverDescription.scala` | ソース | ドライバー記述 |
| StandaloneRestServer.scala | `core/src/main/scala/org/apache/spark/deploy/rest/StandaloneRestServer.scala` | ソース | REST APIサーバー |
| MasterWebUI.scala | `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterWebUI.scala` | ソース | Master Web UI |
| WorkerWebUI.scala | `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerWebUI.scala` | ソース | Worker Web UI |
| ExecutorRunner.scala | `core/src/main/scala/org/apache/spark/deploy/worker/ExecutorRunner.scala` | ソース | Executor起動管理 |
| StandaloneResourceUtils.scala | `core/src/main/scala/org/apache/spark/deploy/StandaloneResourceUtils.scala` | ソース | リソース管理ユーティリティ |
