# 機能設計書 85-YARN連携

## 概要

本ドキュメントは、Apache Hadoop YARNリソースマネージャ上でSparkアプリケーションを実行するための連携機能の設計を記述する。

### 本機能の処理概要

YARN連携機能は、Apache Hadoop YARNのリソースマネージャと統合し、YARNクラスタ上でSparkアプリケーションのリソース取得、ApplicationMasterの起動、Executorコンテナの割り当てと管理を行う。clientモードとclusterモードの両方をサポートする。

**業務上の目的・背景**：多くの企業がHadoopエコシステムを基盤としたデータ基盤を運用しており、YARNはその中核的なリソース管理システムである。Spark YARN連携により、既存のHadoopクラスタ上でSparkジョブを実行でき、MapReduceやHive等の他のYARNアプリケーションとリソースを共有・管理できる。マルチテナント環境でのリソース分離やフェアスケジューリングを活用可能にする。

**機能の利用シーン**：Hadoopクラスタ上でのSparkバッチジョブの実行、YARNキューによるマルチテナントリソース管理、Kerberos認証環境でのセキュアなジョブ実行、HDFS上のデータに対するローカリティ考慮した処理。

**主要な処理内容**：
1. YARNクライアント処理：YARNClientを使用してアプリケーションの申請とリソース要求を送信
2. ApplicationMaster起動：YARN上でApplicationMasterプロセスを起動しExecutor管理を行う
3. Executorコンテナ割り当て：YarnAllocatorでコンテナ要求とリソース取得を管理
4. ステージングディレクトリ管理：JAR、設定ファイル等をHDFS上のステージングディレクトリに配置
5. 委任トークン管理：Kerberos環境での委任トークンの取得と更新

**関連システム・外部連携**：YARN ResourceManager、HDFS、Kerberos KDC、Hadoop委任トークンマネージャ

**権限による制御**：YARN ACL、Kerberos認証、Hadoop委任トークンによるセキュアなリソースアクセス

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | YARN Web UIで間接的にアプリケーション状態を確認可能 |

## 機能種別

デプロイ・クラスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| spark.yarn.queue | String | No | YARNキュー名 | - |
| spark.yarn.am.memory | String | No | AMメモリ量（clientモード） | メモリ形式 |
| spark.driver.memory | String | No | ドライバメモリ量（clusterモード） | メモリ形式 |
| spark.executor.memory | String | No | Executorメモリ量 | メモリ形式 |
| spark.executor.instances | Int | No | Executor数 | 正の整数 |
| spark.yarn.unmanagedAM | Boolean | No | Unmanaged AMモード | Boolean |
| spark.yarn.dist.jars | String | No | 配布するJARファイル | - |
| spark.yarn.dist.files | String | No | 配布するファイル | - |

### 入力データソース

YARN ResourceManager API、HDFS、spark-defaults.conf、Hadoop設定ファイル

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ApplicationId | ApplicationId | YARNアプリケーションID |
| ApplicationReport | ApplicationReport | アプリケーション実行レポート |
| ContainerAllocation | Container[] | 割り当て済みコンテナ情報 |

### 出力先

YARN ResourceManager（リソース要求）、HDFS（ステージングディレクトリ）

## 処理フロー

### 処理シーケンス

```
1. YARNクライアント初期化
   └─ YarnClient.createYarnClient()、hadoopConf設定
2. アプリケーション申請
   └─ YarnClient.createApplication()でApplicationIdを取得
3. ステージングディレクトリ準備
   └─ JAR、設定、委任トークンをHDFSに配置
4. ApplicationMasterコンテキスト構築
   └─ AMのメモリ、コア、コマンド、環境変数を設定
5. アプリケーション投入
   └─ YarnClient.submitApplication()でYARNに投入
6. ApplicationMaster起動
   └─ YARN上でAMプロセスが起動
7. Executor要求
   └─ YarnAllocatorでコンテナ要求を送信
8. Executorコンテナ起動
   └─ 取得したコンテナでExecutorRunnable起動
9. 完了待ち
   └─ アプリケーション完了までステータス監視
```

### フローチャート

```mermaid
flowchart TD
    A[Client初期化] --> B[createApplication]
    B --> C[ステージングディレクトリ準備]
    C --> D[AMコンテキスト構築]
    D --> E[submitApplication]
    E --> F[ApplicationMaster起動]
    F --> G[YarnAllocator初期化]
    G --> H[コンテナ要求]
    H --> I{コンテナ取得?}
    I -->|Yes| J[ExecutorRunnable起動]
    I -->|No| K[待機・リトライ]
    K --> H
    J --> L{全Executor起動?}
    L -->|Yes| M[ジョブ実行]
    L -->|No| H
    M --> N[完了・クリーンアップ]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-85-01 | メモリオーバーヘッド | AMメモリにはDRIVER_MEMORY_OVERHEAD_FACTORを乗じたオーバーヘッドを加算する | clusterモード時 |
| BR-85-02 | デプロイモード判定 | isClusterMode = sparkConf.get(SUBMIT_DEPLOY_MODE) == "cluster" | クライアント初期化時 |
| BR-85-03 | Unmanaged AM | spark.yarn.unmanagedAMがtrue かつ clientモード時にUnmanaged AMを使用 | clientモード時 |
| BR-85-04 | ノードヘルストラッカー | YarnAllocatorNodeHealthTrackerでノードの健全性を監視しブラックリスト管理 | Executor割り当て時 |

### 計算ロジック

AMメモリ計算: clusterモード時は`DRIVER_MEMORY`、clientモード時は`AM_MEMORY`を基準に、`DRIVER_MEMORY_OVERHEAD_FACTOR`を掛けたオーバーヘッドを加算する。最低値として`DRIVER_MIN_MEMORY_OVERHEAD`を保証する。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を直接行わない。HDFS上のステージングディレクトリへのファイル配置のみ。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| ApplicationNotFoundException | YARNエラー | アプリケーションが見つからない場合 | アプリケーションIDを確認 |
| SparkException | リソースエラー | 要求リソースがYARNの上限を超える場合 | リソース設定を調整 |
| IOException | HDFS通信エラー | ステージングディレクトリへのアクセス失敗 | HDFS接続を確認 |

### リトライ仕様

コンテナ要求はYARNのリソーススケジューラにより非同期で処理され、コンテナが利用可能になるまで定期的にポーリングする。

## トランザクション仕様

該当なし（YARNのリソース管理プロトコルに従う）。

## パフォーマンス要件

- LocalityPreferredContainerPlacementStrategyによりデータローカリティを最大化
- ステージングファイルの分散キャッシュプリロードで起動時間を短縮

## セキュリティ考慮事項

- Kerberos認証によるセキュアなクラスタアクセス
- HadoopDelegationTokenManagerによる委任トークンの自動取得・更新
- YarnProxyRedirectFilterによるWebUIプロキシ対応

## 備考

YARN連携はSparkの最も広く使用されるデプロイメントモードの一つである。大規模Hadoopクラスタでのマルチテナント運用に適する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

YARN連携の設定と主要データ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Client.scala (yarn) | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/Client.scala` | **66-100行目**: YARNクライアントの主要フィールド（yarnClient, hadoopConf, isClusterMode, amMemory等） |
| 1-2 | ClientArguments.scala (yarn) | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ClientArguments.scala` | クライアント引数の定義 |

**読解のコツ**: YARN連携はHadoop YARNの標準APIを使用しているため、YarnClient、YarnClientApplication、ContainerLaunchContext等のHadoopクラスの理解が前提となる。

#### Step 2: クライアントの処理フローを理解する

YARNへのアプリケーション投入フローを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Client.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/Client.scala` | **74-100行目**: YARNClient初期化、メモリ計算、オーバーヘッド算出 |

#### Step 3: ApplicationMasterを理解する

YARN上で起動するApplicationMasterの処理を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ApplicationMaster.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ApplicationMaster.scala` | AM起動、Executor管理 |
| 3-2 | YarnAllocator.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnAllocator.scala` | コンテナ要求・割り当てロジック |
| 3-3 | ExecutorRunnable.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ExecutorRunnable.scala` | Executorコンテナ起動 |

### プログラム呼び出し階層図

```
spark-submit --master yarn
    |
    +-- Client.run()
            +-- YarnClient.createApplication()
            +-- setupLaunchEnv() [ステージング準備]
            +-- submitApplication()
                    |
                    +-- ApplicationMaster.main()
                            +-- YarnAllocator
                            |       +-- コンテナ要求
                            |       +-- ExecutorRunnable起動
                            |
                            +-- YarnRMClient
                            +-- ApplicationMasterSource
```

### データフロー図

```
[入力]                      [処理]                        [出力]

SparkConf/Args ───▶ Client ──▶ YarnClient.submit() ──▶ YARN RM
                                    |
                            HDFS staging directory
                                    |
                                    v
                           ApplicationMaster ──▶ YarnAllocator ──▶ Containers
                                                                       |
                                                                       v
                                                               ExecutorRunnable
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Client.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/Client.scala` | ソース | YARNクライアント |
| ApplicationMaster.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ApplicationMaster.scala` | ソース | ApplicationMaster |
| YarnAllocator.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnAllocator.scala` | ソース | コンテナ割り当て管理 |
| ExecutorRunnable.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ExecutorRunnable.scala` | ソース | Executorコンテナ起動 |
| YarnRMClient.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnRMClient.scala` | ソース | ResourceManagerクライアント |
| YarnAllocatorNodeHealthTracker.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/YarnAllocatorNodeHealthTracker.scala` | ソース | ノードヘルストラッカー |
| ClientDistributedCacheManager.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ClientDistributedCacheManager.scala` | ソース | 分散キャッシュ管理 |
| LocalityPreferredContainerPlacementStrategy.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/LocalityPreferredContainerPlacementStrategy.scala` | ソース | ローカリティ配置戦略 |
| ResourceRequestHelper.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/ResourceRequestHelper.scala` | ソース | リソース要求ヘルパー |
| SparkRackResolver.scala | `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/SparkRackResolver.scala` | ソース | ラック解決 |
