# 機能設計書 86-Kubernetes連携

## 概要

本ドキュメントは、Kubernetes上でSparkアプリケーションを実行するための連携機能の設計を記述する。

### 本機能の処理概要

Kubernetes連携機能は、Kubernetes API Serverと統合し、Sparkのドライバーおよびエグゼキュータをコンテナ（Pod）として起動・管理する。Podテンプレート、ボリュームマウント、サービスアカウント等のKubernetes固有のリソース管理をサポートする。

**業務上の目的・背景**：Kubernetesはコンテナオーケストレーションの事実上の標準となっている。Spark Kubernetes連携により、既存のKubernetesクラスタ上でSparkジョブをコンテナとして実行でき、コンテナ化されたCI/CDパイプライン、マイクロサービスアーキテクチャとの統合が容易になる。クラウドネイティブな環境でのSparkワークロードの実行を可能にする。

**機能の利用シーン**：クラウドKubernetesクラスタ（EKS、GKE、AKS）上でのSpark実行、CI/CDパイプラインからのSparkジョブ投入、マイクロサービス環境でのデータ処理、コンテナベースのリソース隔離。

**主要な処理内容**：
1. ドライバーPod構築：KubernetesDriverBuilderでドライバーPodの仕様を構築
2. ドライバーPod作成：Kubernetes APIでドライバーPodを作成
3. ドライバー監視：Watcherでドライバーの状態を監視・ログ出力
4. Executor Pod管理：ドライバー内のKubernetesClusterSchedulerBackendでExecutor Podを管理
5. ボリューム・Secret管理：PVCマウント、ConfigMap、Secretの設定

**関連システム・外部連携**：Kubernetes API Server、Docker/コンテナランタイム、クラウドプロバイダ（AWS、GCP、Azure）

**権限による制御**：Kubernetesサービスアカウント、RBAC（Role-Based Access Control）による権限管理

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | Kubernetes Dashboard等で間接的にPod状態を確認可能 |

## 機能種別

デプロイ・クラスタ管理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| spark.master | String | Yes | k8s://形式のKubernetes APIサーバーURL | k8s://プレフィックス |
| spark.kubernetes.container.image | String | Yes | Sparkコンテナイメージ | - |
| spark.kubernetes.namespace | String | No | Kubernetesネームスペース（デフォルトdefault） | - |
| spark.kubernetes.authenticate.driver.serviceAccountName | String | No | ドライバーサービスアカウント名 | - |
| spark.kubernetes.driver.pod.template | String | No | ドライバーPodテンプレートファイルパス | - |
| spark.kubernetes.executor.pod.template | String | No | ExecutorPodテンプレートファイルパス | - |
| spark.kubernetes.submission.waitAppCompletion | Boolean | No | 完了待機するか | Boolean |

### 入力データソース

Kubernetes API Server、Podテンプレートファイル、spark-defaults.conf

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Driver Pod | Pod | 起動されたドライバーPod |
| Executor Pods | Pod[] | 起動されたExecutor Pod群 |
| Application Status | Pod.Status | アプリケーション実行状態 |

### 出力先

Kubernetes API Server（Pod作成・管理）

## 処理フロー

### 処理シーケンス

```
1. クライアント引数パース
   └─ ClientArguments.fromCommandLineArgs()でメインクラス、リソース情報を解析
2. KubernetesDriverConf構築
   └─ SparkConfからK8s固有設定を抽出
3. ドライバーPod仕様構築
   └─ KubernetesDriverBuilderでPod仕様をFeature単位で組み立て
4. ドライバーPod作成
   └─ kubernetesClient.pods().create()でAPI Server経由でPod作成
5. Watcher設定
   └─ ドライバーPodの状態変更を監視するWatcherを起動
6. 完了待機（オプション）
   └─ spark.kubernetes.submission.waitAppCompletion=trueの場合、Pod完了まで待機
7. Executor管理（ドライバー内）
   └─ KubernetesClusterSchedulerBackendでExecutor Podを起動・管理
```

### フローチャート

```mermaid
flowchart TD
    A[spark-submit --master k8s://] --> B[ClientArguments解析]
    B --> C[KubernetesDriverConf構築]
    C --> D[KubernetesDriverBuilder]
    D --> E{Feature適用}
    E --> F[BasicDriverFeature]
    E --> G[MountSecretsFeature]
    E --> H[MountVolumesFeature]
    E --> I[PodTemplateConfigMapFeature]
    F & G & H & I --> J[Driver Pod仕様完成]
    J --> K[kubernetesClient.create Pod]
    K --> L[Watcher起動]
    L --> M{waitAppCompletion?}
    M -->|Yes| N[Pod完了待機]
    M -->|No| O[終了]
    N --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-86-01 | リソースタイプ判定 | mainAppResource の型（Java/Python/R）に応じてPod構成を切り替える | ドライバーPod構築時 |
| BR-86-02 | オーナーリファレンス | Executor PodはドライバーPodのオーナーリファレンスを持ち、ドライバー削除時に自動クリーンアップ | Executor Pod作成時 |
| BR-86-03 | Podテンプレート適用 | spark.kubernetes.driver.pod.template指定時はテンプレートをベースにPodを構築する | Pod構築時 |
| BR-86-04 | 完了待機 | spark.kubernetes.submission.waitAppCompletion=trueの場合、ドライバーPod完了まで待機する | submit後 |

### 計算ロジック

特になし。

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベース操作を行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Pod作成エラー | Kubernetes APIエラー（リソース不足等） | リソース設定の調整、ネームスペースの確認 |
| - | 認証エラー | サービスアカウント権限不足 | RBAC設定を確認 |
| - | イメージプルエラー | コンテナイメージ取得失敗 | イメージ名とレジストリアクセスを確認 |

### リトライ仕様

Kubernetes API呼び出しの一時的なエラーに対してfabric8クライアントの組み込みリトライを活用する。

## トランザクション仕様

該当なし（Kubernetes APIのリソース作成は冪等ではないが、オーナーリファレンスによるカスケード削除で整合性を保つ）。

## パフォーマンス要件

- ドライバーPodの起動はKubernetesスケジューラの性能に依存
- Executor Podのスケールアウトは動的リソース割り当てと連携

## セキュリティ考慮事項

- Kubernetesサービスアカウントによる権限管理
- RBAC設定によるPod作成・削除権限の制御
- Secret/ConfigMapによる機密情報の管理

## 備考

Kubernetes連携はSpark 2.3で導入され、GA（Generally Available）はSpark 3.1以降。fabric8 Kubernetesクライアントライブラリを使用してKubernetes APIと通信する。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Kubernetes固有のデータ構造と設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | KubernetesClientApplication.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/submit/KubernetesClientApplication.scala` | **45-85行目**: ClientArgumentsケースクラス（mainAppResource, mainClass, driverArgs, proxyUser） |
| 1-2 | KubernetesConf.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/KubernetesConf.scala` | K8s固有設定のコンフィグクラス |
| 1-3 | Config.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/Config.scala` | K8s関連の設定キー定義 |
| 1-4 | Constants.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/Constants.scala` | 定数定義（ラベル名、アノテーション等） |

**読解のコツ**: MainAppResourceは`JavaMainAppResource`、`PythonMainAppResource`、`RMainAppResource`のサブタイプがあり、アプリケーション種別に応じてPod構成が異なる。

#### Step 2: エントリーポイントを理解する

アプリケーション投入の流れを追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | KubernetesClientApplication.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/submit/KubernetesClientApplication.scala` | **88-100行目**: Client クラス - KubernetesDriverConf, builder, kubernetesClient, watcherの注入 |

**主要処理フロー**:
1. **53-85行目**: ClientArguments.fromCommandLineArgs()で--primary-java-resource、--main-class等をパース
2. **98-100行目**: Client(conf, builder, kubernetesClient, watcher)でクライアント構築

#### Step 3: Feature構成パターンを理解する

ドライバーPod仕様のFeatureベース構築を追う。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | features/ | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/features/` | 各Feature実装（BasicDriverFeature, MountSecretsFeature等） |

### プログラム呼び出し階層図

```
spark-submit --master k8s://api-server
    |
    +-- KubernetesClientApplication.start()
            +-- ClientArguments.fromCommandLineArgs()
            +-- KubernetesDriverConf
            +-- KubernetesDriverBuilder
            |       +-- BasicDriverFeatureStep
            |       +-- MountSecretsFeatureStep
            |       +-- MountVolumesFeatureStep
            |       +-- PodTemplateConfigMapStep
            |
            +-- Client.run()
                    +-- kubernetesClient.pods().create(driverPod)
                    +-- addOwnerReference(executorPods, driverPod)
                    +-- Watcher.start()
```

### データフロー図

```
[入力]                        [処理]                         [出力]

SparkConf/Args ───▶ KubernetesDriverConf ──▶ KubernetesDriverBuilder
                                                        |
                                              Feature Pipeline
                                                        |
                                                        v
                                              SparkPod (Driver)
                                                        |
K8s API Server ◀── kubernetesClient.create() ◀─────────+
                                                        |
                                              Watcher (状態監視)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| KubernetesClientApplication.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/submit/KubernetesClientApplication.scala` | ソース | K8sサブミットのエントリーポイント |
| KubernetesConf.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/KubernetesConf.scala` | ソース | K8s設定管理 |
| Config.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/Config.scala` | ソース | 設定キー定義 |
| Constants.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/Constants.scala` | ソース | 定数定義 |
| KubernetesUtils.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/KubernetesUtils.scala` | ソース | ユーティリティ |
| SparkPod.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/SparkPod.scala` | ソース | SparkPodデータ構造 |
| KubernetesVolumeUtils.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/KubernetesVolumeUtils.scala` | ソース | ボリュームユーティリティ |
| SparkKubernetesClientFactory.scala | `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/SparkKubernetesClientFactory.scala` | ソース | K8sクライアントファクトリ |
