---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：1-SparkContext管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件の具体値**：デフォルト値の正確性要確認
  2. **セキュリティ設定パラメータ名**：最新バージョンでの正確性要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `core/src/main/scala/org/apache/spark/SparkContext.scala` 86行目 - クラス定義
- E-02: `core/src/main/scala/org/apache/spark/SparkContext.scala` 77-85行目 - Scaladocコメント
- E-03: `core/src/main/scala/org/apache/spark/SparkContext.scala` 93-96行目 - Executor上生成防止
- E-04: `core/src/main/scala/org/apache/spark/SparkContext.scala` 101行目 - markPartiallyConstructed
- E-05: `core/src/main/scala/org/apache/spark/SparkContext.scala` 216-246行目 - 内部変数定義
- E-06: `core/src/main/scala/org/apache/spark/SparkContext.scala` 409-747行目 - 初期化tryブロック
- E-07: `core/src/main/scala/org/apache/spark/SparkContext.scala` 420-425行目 - master/appName検証
- E-08: `core/src/main/scala/org/apache/spark/SparkContext.scala` 492行目 - LiveListenerBus生成
- E-09: `core/src/main/scala/org/apache/spark/SparkContext.scala` 497行目 - AppStatusStore生成
- E-10: `core/src/main/scala/org/apache/spark/SparkContext.scala` 501行目 - SparkEnv生成
- E-11: `core/src/main/scala/org/apache/spark/SparkContext.scala` 519-526行目 - Web UI生成
- E-12: `core/src/main/scala/org/apache/spark/SparkContext.scala` 590-591行目 - HeartbeatReceiver
- E-13: `core/src/main/scala/org/apache/spark/SparkContext.scala` 600-603行目 - Scheduler生成
- E-14: `core/src/main/scala/org/apache/spark/SparkContext.scala` 650行目 - BlockManager初期化
- E-15: `core/src/main/scala/org/apache/spark/SparkContext.scala` 736-747行目 - エラー時stop処理
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` 2行目 - 機能定義
- E-17: `core/src/main/scala/org/apache/spark/SparkContext.scala` 446-448行目 - YARN制約
- E-18: `core/src/main/scala/org/apache/spark/SparkContext.scala` 708-717行目 - ShutdownHook

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkContextはアプリケーションのエントリポイント | E-02 | ○ |
| C-02 | 1JVMにつき1つのSparkContextのみアクティブ | E-02, E-04 | ○ |
| C-03 | Executor上でのSparkContext生成は禁止 | E-03 | ○ |
| C-04 | SparkConfにmaster, appNameが必須 | E-07 | ○ |
| C-05 | 初期化順序: SparkEnv→UI→Scheduler→DAGScheduler | E-06, E-10, E-11, E-13 | ○ |
| C-06 | LiveListenerBusがイベントバスとして機能 | E-08 | ○ |
| C-07 | AppStatusStoreがアプリケーション状態を管理 | E-09 | ○ |
| C-08 | HeartbeatReceiverがExecutorハートビートを受信 | E-12 | ○ |
| C-09 | TaskScheduler/SchedulerBackendがクラスタマネージャに応じて選択される | E-13 | ○ |
| C-10 | BlockManagerがapplicationIdで初期化される | E-14 | ○ |
| C-11 | YARNクラスタモードでspark.yarn.app.idが必要 | E-17 | ○ |
| C-12 | 初期化エラー時はstop()でクリーンアップ | E-15 | ○ |
| C-13 | ShutdownHookによるJVM終了時のstop()呼び出し | E-18 | ○ |
| C-14 | 内部変数はnullで初期化後、tryブロック内で順次設定 | E-05, E-06 | ○ |
| C-15 | 停止済みSparkContextへのアクセスでIllegalStateException | E-02 | ○ |
| C-16 | SecurityManagerによるACL制御 | E-06 | ○ |
| C-17 | executorMemoryのデフォルト値は1024MB | E-06 | ○ |
| C-18 | MetricsSystemがアプリケーションID設定後に起動 | E-06 | ○ |
| C-19 | 初期化時間は通常数秒以内 | **根拠なし** | △ |
| C-20 | ハートビート間隔のデフォルト値は10秒 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-19: 初期化時間の「数秒以内」は実測値に基づくものではなく、一般的な経験則に基づく推定
  - 候補：パフォーマンステスト結果 / ベンチマーク資料 / 公式ドキュメント
- C-20: ハートビート間隔のデフォルト値は設定ファイル（config package）を確認する必要がある
  - 候補：`internal/config/package.scala` / 公式設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: SparkContextの基本構造と初期化フロー - ソースコードから直接確認済み
- 0: エラー処理パターン - ソースコードのtry-catch構造から確認済み
- 1: パフォーマンス要件の具体値 - 実測値ではなく推定に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] SparkContext初期化シーケンスの各ステップが最新コードと一致しているか
- [ ] パフォーマンス要件のデフォルト値が公式ドキュメントと一致しているか
- [ ] セキュリティ関連の設定パラメータ名が最新バージョンで正確か
- [ ] runJobメソッドの詳細な処理フローが正確か
