---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：14-セキュリティ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **HadoopDelegationTokenManagerの詳細実装**：ファイル存在のみ確認、内容未読取
  2. **暗号化オーバーヘッドの定量値**：コードからは確認不可

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/SecurityManager.scala`（先頭100行読取済み）
- E-02: `core/src/main/scala/org/apache/spark/security/CryptoStreamUtils.scala`（先頭80行読取済み）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（全文読取済み）
- E-04: `core/src/main/scala/org/apache/spark/security/`（ディレクトリ内ファイル一覧確認済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SecurityManagerクラスがセキュリティの中心 | E-01 (47行) | ○ |
| C-02 | ACL管理（viewAcls, modifyAcls, adminAcls） | E-01 (59-75行) | ○ |
| C-03 | デフォルトACLユーザーにシステムユーザーとSPARK_USERを含む | E-01 (78-79行) | ○ |
| C-04 | ネットワーク認証はspark.authenticateで制御 | E-01 (58行) | ○ |
| C-05 | SecretKeyHolderトレイトを実装 | E-01 (51行) | ○ |
| C-06 | SSL RPC設定の読み込み | E-01 (89-90行) | ○ |
| C-07 | CryptoStreamUtilsでAES暗号化 | E-02 (41-60行) | ○ |
| C-08 | IV長は16バイト固定 | E-02 (44行) | ○ |
| C-09 | 画面No.9との関連（機密情報マスク） | E-03 (37行) | ○ |
| C-10 | ワイルドカードACL "*"の存在 | E-01 (56行) | ○ |
| C-11 | GroupMappingServiceProviderでグループ解決 | E-04 (ファイル存在確認) | ○ |
| C-12 | SocketAuthHelper/SocketAuthServerの存在 | E-04 (ファイル存在確認) | ○ |
| C-13 | HadoopDelegationTokenManagerの委任トークン管理 | **根拠なし** | △ |
| C-14 | 暗号化オーバーヘッドは10-20%程度 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: HadoopDelegationTokenManager.scalaの内容を読取していないため、具体的な実装詳細は未確認
  - 候補：HadoopDelegationTokenManager.scalaの読取
- C-14: パフォーマンスオーバーヘッドの数値は一般的な知見に基づく推定値であり、Sparkコード内には記載なし
  - 候補：Sparkベンチマーク結果 / Apache Commons Cryptoドキュメント

## 5) リスクフラグ（レビュー観点）
- 1: 委任トークン管理の詳細が未確認（中リスク）
- 1: 暗号化パフォーマンスの定量値は推定（中リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] SecurityManager.scalaの全文を確認し、checkUIViewPermissions/checkModifyPermissionsの実装を検証
- [ ] HadoopDelegationTokenManager.scalaを確認
- [ ] 暗号化パフォーマンスの記述を実測値で検証または削除
