---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：15-動的リソース割り当て

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 全Claimに根拠あり。ExecutorMonitorの詳細は補足読取が望ましい。

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala`（全文読取済み）
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（全文読取済み）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（全文読取済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 100ms間隔の定期スケジューリング | E-01 (156行, 255行) | ○ |
| C-02 | 指数的バックオフ方式のExecutor追加 | E-01 (57-63行 コメント, 457-462行) | ○ |
| C-03 | maxExecutorsの上限制約 | E-01 (510-515行) | ○ |
| C-04 | minExecutorsの下限制約 | E-01 (491行, 559行) | ○ |
| C-05 | ResourceProfile単位での管理 | E-01 (44-46行 コメント, 141-149行) | ○ |
| C-06 | 設定値バリデーション | E-01 (189-239行) | ○ |
| C-07 | Decommission対応 | E-01 (134行, 584-593行) | ○ |
| C-08 | External Shuffle Service要件 | E-01 (212-226行) | ○ |
| C-09 | ExecutorAllocationListenerによるイベント監視 | E-01 (655行) | ○ |
| C-10 | maxNumExecutorsNeeded計算式 | E-01 (297-330行) | ○ |
| C-11 | schedulerBacklogTimeoutでの追加タイミング制御 | E-01 (627-633行) | ○ |
| C-12 | クラスタマネージャ到達不可時のロールバック | E-01 (437-443行, 477-480行) | ○ |
| C-13 | 初期化期間中のExecutor追加抑制 | E-01 (176行, 368-372行) | ○ |
| C-14 | YARN AMリスタート時のreset() | E-01 (282-291行) | ○ |
| C-15 | 画面No.10,24との関連 | E-03 (42行, 84行) | ○ |
| C-16 | executorAllocationRatioの制約(0 < ratio <= 1.0) | E-01 (235-238行) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全Claimに根拠あり、低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ExecutorMonitor.scalaのtimedOutExecutors()実装を確認
- [ ] executorAllocationRatioのデフォルト値を確認
- [ ] Streaming用ExecutorAllocationManagerとの違いを確認
