---
generated_at: 2026-02-04 11:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：19-SQLパーサー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **AstBuilder.scalaの詳細実装**：ファイル存在は確認したが巨大なファイルのため全文は未読取

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/parser/ParserInterface.scala`（全文読取済み）
- E-02: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/parser/AbstractSqlParser.scala`（全文読取済み）
- E-03: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/parser/`（ディレクトリ内ファイル一覧確認済み）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（全文読取済み）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ParserInterfaceがparsePlan, parseExpression等の統一APIを提供 | E-01 (30-83行) | ○ |
| C-02 | DataTypeParserInterfaceを継承 | E-01 (30行) | ○ |
| C-03 | AbstractSqlParserがANTLR4パーサー基盤 | E-02 (33行) | ○ |
| C-04 | astBuilder抽象メソッドでAstBuilder実装を指定 | E-02 (34行) | ○ |
| C-05 | parsePlan()でcompoundOrSingleStatementルールを使用 | E-02 (93-94行) | ○ |
| C-06 | CompoundPlanStatementとLogicalPlanの分岐処理 | E-02 (96-101行) | ○ |
| C-07 | withErrorHandling()でStackOverflowErrorをキャッチ | E-02 (113-122行) | ○ |
| C-08 | parseQuery()でLEGACY_PARSE_QUERY_WITHOUT_EOF設定を参照 | E-02 (77行) | ○ |
| C-09 | parsePlanWithParametersのデフォルト実装 | E-01 (42-46行) | ○ |
| C-10 | SubstituteParamsParser, ParameterContext等の存在 | E-03 (ファイル一覧) | ○ |
| C-11 | SparkParserErrorStrategyの存在 | E-03 (ファイル一覧) | ○ |
| C-12 | parseRoutineParam()のサポート | E-01 (82-83行), E-02 (106-111行) | ○ |
| C-13 | @throws[ParseException]アノテーション | E-01 (34行, 51行等) | ○ |
| C-14 | AstBuilder.visitXxx()によるLogicalPlan生成の具体的な変換ルール | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: AstBuilder.scalaは巨大なファイルであり全文読取を行っていない。具体的なvisitXxxメソッドの実装詳細は未確認。
  - 候補：AstBuilder.scalaの読取 / ANTLR4文法ファイル（SqlBaseParser.g4）の参照

## 5) リスクフラグ（レビュー観点）
- 1: AstBuilderの変換ルール詳細が未確認（中リスク）
- 0: パーサーAPI/フレームワーク構造は全てソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] AstBuilder.scalaの主要visitメソッドを確認
- [ ] ANTLR4文法ファイル（SqlBaseParser.g4）を確認
- [ ] SparkSqlParser（sql/core側のメインパーサー）との関係を確認
