---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：22-コード生成（Whole-Stage CodeGen）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **TPC-Hベンチマーク10倍性能向上**：定量値の根拠不足
  2. **Janinoコンパイラの具体的な制限値**：デフォルト値の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/WholeStageCodegenExec.scala` - WholeStageCodegenExec実装
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.22
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面No.15との関連
- E-04: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/expressions/codegen/` - コード生成基盤

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CodegenSupportトレイトがコード生成対応オペレータのインターフェース | E-01（47行目） | ○ |
| C-02 | variablePrefixが各オペレータ種別に応じた接頭辞を定義 | E-01（50-63行目） | ○ |
| C-03 | supportCodegenのデフォルトがtrue | E-01（77行目） | ○ |
| C-04 | produce()がコード生成のエントリポイント | E-01（94行目） | ○ |
| C-05 | consume()が親オペレータへの結果受け渡しを行う | E-01（153行目） | ○ |
| C-06 | doProduce()がサブクラスでオーバーライドされる | E-01（121行目） | ○ |
| C-07 | メソッド分割がsplitConsumeFuncByOperator設定で制御される | E-01（193行目） | ○ |
| C-08 | evaluateVariablesが二重評価を防止する | E-01（279-283行目） | ○ |
| C-09 | SQL Execution Detail画面でCodegenノードが表示される | E-03（画面No.15, 機能No.22） | ○ |
| C-10 | 物理実行計画からJavaバイトコードを動的生成 | E-02（機能一覧No.22の説明） | ○ |
| C-11 | コード生成失敗時にVolcanoモデルへフォールバック | E-01（制御フローの分析） | ○ |
| C-12 | HashAggregateExec等の各種Execがコード生成対応 | E-01（51-60行目: variablePrefixの定義一覧） | ○ |
| C-13 | CodegenContextが変数名管理とオブジェクト参照管理を提供 | E-01（96行目: ctx.freshNamePrefix） | ○ |
| C-14 | UnsafeRow生成コードがGenerateUnsafeProjectionで生成される | E-01（135行目: GenerateUnsafeProjection.createCode） | ○ |
| C-15 | inputRDDs()でRDDを取得する | E-01（89行目: def inputRDDs()） | ○ |
| C-16 | JaninoコンパイラによるJavaソースコードコンパイル | E-01（インポート文からJanino使用確認） | ○ |
| C-17 | paramLength計算でJavaメソッドパラメータ制限を考慮 | E-01（195-197行目） | ○ |
| C-18 | constructConsumeParametersで引数リストを構築 | E-01（240-273行目） | ○ |
| C-19 | TPC-Hで10倍以上の性能向上 | **根拠なし** | △ |
| C-20 | spark.sql.codegen.hugeMethodLimitのデフォルト値が65535 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TPC-Hベンチマーク結果はソースコードからは直接確認できない
  - 候補：Sparkの公式ブログ / Databricksの技術論文 / 公式ドキュメント
- hugeMethodLimitのデフォルト値はSQLConf定義ファイルで確認する必要がある
  - 候補：`sql/catalyst/src/main/scala/org/apache/spark/sql/internal/SQLConf.scala`

## 5) リスクフラグ（レビュー観点）
- 0: コード生成の基本アーキテクチャ - ソースコードで確認済みで低リスク
- 0: Produce/Consumeパターン - 行番号付きで確認済み
- 1: パフォーマンス数値 - 外部資料からの引用で中リスク
- 0: エラーハンドリング - フォールバック機構がコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] CodegenSupportトレイトの主要メソッド（produce, consume, doProduce, doConsume）の説明が正確か
- [ ] コード生成設定パラメータのデフォルト値がSQLConfと一致するか
- [ ] フォールバック機構の説明が正確か
- [ ] 関連画面マッピングが正確か
