---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：25-ORCサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ORC暗号化機能（encryption zones対応）の詳細**：Spark側の対応状況確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/datasources/orc/OrcFileFormat.scala` - OrcFileFormat実装
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/execution/datasources/orc/` - ORCディレクトリ全体
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.25

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OrcFileFormatがFileFormat/DataSourceRegister/SessionStateHelperを実装 | E-01（49-53行目） | ○ |
| C-02 | shortName()が"orc"を返す | E-01（55行目） | ○ |
| C-03 | inferSchema()がOrcUtils.inferSchemaに委譲 | E-01（63-68行目） | ○ |
| C-04 | prepareWrite()でOrcOptionsとCOMPRESS属性を設定 | E-01（70-80行目） | ○ |
| C-05 | OrcFiltersがフィルタプッシュダウンを実現 | E-02（OrcFilters.scalaの存在） | ○ |
| C-06 | OrcFiltersBaseが基底クラスとして存在 | E-02（OrcFiltersBase.scalaの存在） | ○ |
| C-07 | OrcSerializerがSpark→ORC型変換を実現 | E-02（OrcSerializer.scalaの存在） | ○ |
| C-08 | OrcDeserializerがORC→Spark型変換を実現 | E-02（OrcDeserializer.scalaの存在） | ○ |
| C-09 | OrcOutputWriterが書き込みを実現 | E-02（OrcOutputWriter.scalaの存在） | ○ |
| C-10 | OrcOptionsがオプション定義を提供 | E-02（OrcOptions.scalaの存在） | ○ |
| C-11 | OrcUtilsがユーティリティ関数を提供 | E-02（OrcUtils.scalaの存在） | ○ |
| C-12 | OrcShimUtilsが互換ユーティリティを提供 | E-02（OrcShimUtils.scalaの存在） | ○ |
| C-13 | Hadoop FileSystem APIに依存 | E-01（23-26行目: Hadoopインポート） | ○ |
| C-14 | Apache ORCライブラリを使用 | E-01（28-31行目: ORCインポート） | ○ |
| C-15 | ORC暗号化機能への対応 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ORC暗号化機能のSpark側対応状況はテストコード（OrcEncryptionSuite.scala）の確認が必要
  - 候補：`sql/core/src/test/scala/org/apache/spark/sql/execution/datasources/orc/OrcEncryptionSuite.scala`

## 5) リスクフラグ（レビュー観点）
- 0: OrcFileFormatの基本構造 - ソースコードで確認済み
- 0: フィルタプッシュダウン - 関連ファイルの存在確認済み
- 0: シリアライゼーション - 関連ファイルの存在確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] OrcFileFormatの主要メソッドが正確に記述されているか
- [ ] フィルタプッシュダウンのSearchArgument変換が正確か
- [ ] OrcSerializer/OrcDeserializerの型マッピングが正確か
- [ ] 圧縮コーデックの選択肢が網羅されているか
