---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：28-JDBCデータソース

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **isolationLevel設定の具体的なデフォルト値**：JDBCOptions実装の確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/jdbc/JdbcDialects.scala` - JdbcDialect基底クラス
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/jdbc/` - JDBCディレクトリ全体
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧No.28
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | JdbcType case classが型マッピングの基本構造 | E-01（62行目） | ○ |
| C-02 | JdbcDialectが@DeveloperApi注釈付き | E-01（30行目: @DeveloperApiインポート） | ○ |
| C-03 | MySQLDialectが存在する | E-02（MySQLDialect.scalaの存在） | ○ |
| C-04 | PostgresDialectが存在する | E-02（PostgresDialect.scalaの存在） | ○ |
| C-05 | OracleDialectが存在する | E-02（OracleDialect.scalaの存在） | ○ |
| C-06 | MsSqlServerDialectが存在する | E-02（MsSqlServerDialect.scalaの存在） | ○ |
| C-07 | DB2Dialectが存在する | E-02（DB2Dialect.scalaの存在） | ○ |
| C-08 | DerbyDialectが存在する | E-02（DerbyDialect.scalaの存在） | ○ |
| C-09 | H2Dialectが存在する | E-02（H2Dialect.scalaの存在） | ○ |
| C-10 | TeradataDialectが存在する | E-02（TeradataDialect.scalaの存在） | ○ |
| C-11 | SnowflakeDialectが存在する | E-02（SnowflakeDialect.scalaの存在） | ○ |
| C-12 | DatabricksDialectが存在する | E-02（DatabricksDialect.scalaの存在） | ○ |
| C-13 | AggregatedDialectが複合方言を提供 | E-02（AggregatedDialect.scalaの存在） | ○ |
| C-14 | JdbcConnectionProviderが接続管理を提供 | E-02（JdbcConnectionProvider.scalaの存在） | ○ |
| C-15 | JdbcSQLQueryBuilderがSQLクエリ生成を提供 | E-02（JdbcSQLQueryBuilder.scalaの存在） | ○ |
| C-16 | ServiceLoaderによるDialect拡張 | E-01（23行目: ServiceLoaderインポート） | ○ |
| C-17 | Connector Catalog統合 | E-01（37-41行目: connector.catalog関連インポート） | ○ |
| C-18 | isolationLevel設定によるトランザクション分離レベル制御 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- isolationLevel設定のデフォルト値はJDBCOptions.scalaの確認が必要
  - 候補：`sql/core/src/main/scala/org/apache/spark/sql/execution/datasources/jdbc/JDBCOptions.scala`

## 5) リスクフラグ（レビュー観点）
- 0: JdbcDialect構造とDialect一覧 - ソースコードで確認済み
- 0: 型マッピング - JdbcType構造の確認済み
- 0: SQL生成 - JdbcSQLQueryBuilderの確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 対応データベースDialectの一覧が網羅されているか
- [ ] パーティション分割の計算ロジックが正確か
- [ ] 書き込みモード（SaveMode）の動作説明が正確か
- [ ] セキュリティ（認証方式）の記述が正確か
