---
generated_at: 2026-02-04 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-DAGスケジューラ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **spark.stage.maxConsecutiveAttemptsのデフォルト値**：設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` 58-100行目 - Scaladoc
- E-02: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` - submitJob()
- E-03: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` - handleJobSubmitted()
- E-04: `core/src/main/scala/org/apache/spark/scheduler/DAGSchedulerEvent.scala` - イベント定義
- E-05: `core/src/main/scala/org/apache/spark/scheduler/Stage.scala` - ステージ基底クラス
- E-06: `core/src/main/scala/org/apache/spark/scheduler/ResultStage.scala` - 結果ステージ
- E-07: `core/src/main/scala/org/apache/spark/scheduler/ShuffleMapStage.scala` - シャッフルステージ
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` 4行目 - 機能定義
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連定義
- E-10: `core/src/main/scala/org/apache/spark/SparkContext.scala` 603行目 - DAGScheduler生成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DAGSchedulerはジョブをステージに分割しDAGを構築 | E-01 | ○ |
| C-02 | シャッフル境界でステージを分割 | E-01 | ○ |
| C-03 | ResultStageとShuffleMapStageの2種類のステージ | E-01, E-06, E-07 | ○ |
| C-04 | イベント駆動型アーキテクチャ（DAGSchedulerEventProcessLoop） | E-04 | ○ |
| C-05 | キャッシュ済みパーティションの追跡と再利用 | E-01 | ○ |
| C-06 | シャッフル出力ファイル消失時のステージ再実行 | E-01 | ○ |
| C-07 | データローカリティの計算（getPreferredLocs） | E-01 | ○ |
| C-08 | 画面1,2,3,4,5,15,19との関連 | E-09 | ○ |
| C-09 | SparkContext内でDAGScheduler生成 | E-10 | ○ |
| C-10 | 同一RDD使用時のステージ共有 | E-01 | ○ |
| C-11 | 単一イベントループスレッドで順次処理 | E-01 | ○ |
| C-12 | ジョブIDとステージIDはシーケンシャル | E-01 | ○ |
| C-13 | FetchFailedException時の親ステージ再実行 | E-01 | ○ |
| C-14 | submitMissingTasks()でTaskSetを生成 | E-01 | ○ |
| C-15 | MapOutputTrackerでシャッフル出力を追跡 | E-01 | ○ |
| C-16 | spark.stage.maxConsecutiveAttemptsのデフォルト値は4 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: spark.stage.maxConsecutiveAttemptsのデフォルト値はconfigパッケージで確認が必要
  - 候補：`internal/config/package.scala` / 公式設定ドキュメント / DAGScheduler.scala内の参照

## 5) リスクフラグ（レビュー観点）
- 0: DAGSchedulerの基本設計 - Scaladocから直接確認済み
- 0: ステージ分割ロジック - ソースコードの設計コメントから確認済み
- 1: ステージリトライ回数のデフォルト値 - 設定ファイルの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ステージ分割ロジックの説明が正確か
- [ ] イベント駆動処理のフローが最新コードと一致しているか
- [ ] 画面関連マッピングが画面機能マッピング.csvと一致しているか
- [ ] ステージリトライのデフォルト値が正確か
