---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：31-UDF/UDAF/UDTFサポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **Python UDF実行のシリアライゼーションオーバーヘッド**：定量的根拠なし
  2. **永続関数のHiveメタストアトランザクション制御**：詳細コード未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/classic/UDFRegistration.scala`
- E-02: `sql/core/src/main/scala/org/apache/spark/sql/UDTFRegistration.scala`
- E-03: `sql/core/src/main/scala/org/apache/spark/sql/execution/aggregate/udaf.scala`
- E-04: `sql/api/src/main/scala/org/apache/spark/sql/functions.scala`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UDFRegistrationがFunctionRegistryに関数を登録する | E-01 (47-113行目) | ○ |
| C-02 | UDTFRegistrationがTableFunctionRegistryに登録する | E-02 (34-49行目) | ○ |
| C-03 | Java UDFは最大22引数対応（UDF0〜UDF22） | E-01 (161-186行目) | ○ |
| C-04 | registerJavaはリフレクションでクラスロードする | E-01 (141-196行目) | ○ |
| C-05 | ScalaUDAFはImperativeAggregateを継承する | E-03 (349-359行目) | ○ |
| C-06 | ScalaUDAFのinitialize/update/merge/evalの4ステップ | E-03 (448-473行目) | ○ |
| C-07 | ScalaAggregatorはTypedImperativeAggregateを継承する | E-03 (487-501行目) | ○ |
| C-08 | ResolveEncodersInScalaAggがエンコーダーを解決する | E-03 (575-585行目) | ○ |
| C-09 | UserDefinedAggregateFunction は3.0.0で非推奨 | E-01 (78-79行目) | ○ |
| C-10 | UDTF は @Evolving アノテーション付き | E-02 (30行目) | ○ |
| C-11 | UDTF は Spark 3.5.0 で追加 | E-02 (28行目) | ○ |
| C-12 | registerJavaUDAFがArtifactManager経由でクラスロード | E-01 (124行目) | ○ |
| C-13 | 同名関数は上書きされる（createOrReplace） | E-01 (111行目) | ○ |
| C-14 | パラメータ数バリデーションがregister内で実施される | E-01 (95-106行目) | ○ |
| C-15 | Python UDFはpython_udfソースで登録される | E-01 (64行目) | ○ |
| C-16 | Python UDTFはpython_udtfソースで登録される | E-02 (49行目) | ○ |
| C-17 | ScalaAggregator.applyがUserDefinedAggregatorから構築 | E-03 (557-569行目) | ○ |
| C-18 | BufferSetterGetterUtilsが型別getter/setterを提供 | E-03 (37-228行目) | ○ |
| C-19 | Python UDFのシリアライゼーションオーバーヘッド記述 | **根拠なし** | △ |
| C-20 | 永続関数のHiveメタストアトランザクション | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Python UDFの実行パフォーマンス影響に関する定量データが不足
  - 候補：ベンチマークテスト / Sparkドキュメント / 性能プロファイル結果
- Hiveメタストア永続関数登録時のトランザクション詳細が未確認
  - 候補：sql/hive/ 配下のソースコード / HiveExternalCatalog.scala

## 5) リスクフラグ（レビュー観点）
- 0: UDF登録フローの記述 - ソースコードと完全一致
- 0: UDAF内部実装の記述 - ソースコードと完全一致
- 1: パフォーマンス要件の記述 - 定量根拠が部分的に不足

## 6) レビュアーチェックリスト（最小）
- [ ] UDF登録フロー（FunctionRegistry.createOrReplaceTempFunction）の記述が正確か
- [ ] ScalaUDAF/ScalaAggregatorの処理ステップの記述が正確か
- [ ] Java UDFリフレクション登録の手順が正しいか
- [ ] Python UDFのパフォーマンス影響に関する記述の妥当性を確認
- [ ] 永続関数に関する記述の追加情報が必要か判断
