---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：33-Protobufデータフォーマット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **DynamicMessageベースがJavaクラス生成より低速という記述**：定量根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/ProtobufDataToCatalyst.scala`
- E-02: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/CatalystDataToProtobuf.scala`
- E-03: `connector/protobuf/src/main/scala/org/apache/spark/sql/protobuf/utils/ProtobufUtils.scala`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProtobufDataToCatalystがUnaryExpressionを継承 | E-01 (37-38行目) | ○ |
| C-02 | 入力型がBinaryType | E-01 (40行目) | ○ |
| C-03 | ProtobufUtils.buildDescriptorでDescriptor構築 | E-01 (49-50行目) | ○ |
| C-04 | TypeRegistryの条件分岐（3パターン） | E-01 (55-70行目) | ○ |
| C-05 | DynamicMessage.parseFromでバイナリ解析 | E-01 (95行目) | ○ |
| C-06 | Unknown Fieldsの既知フィールド番号検証 | E-01 (99-106行目) | ○ |
| C-07 | ParseModeがPermissiveとFailFastのみ | E-01 (74-80行目) | ○ |
| C-08 | PermissiveModeでnull返却 | E-01 (84行目) | ○ |
| C-09 | CatalystDataToProtobufの出力型がBinaryType | E-02 (36行目) | ○ |
| C-10 | ProtobufSerializer.serializeの使用 | E-02 (41-42行目) | ○ |
| C-11 | DynamicMessage.toByteArrayで出力 | E-02 (45-46行目) | ○ |
| C-12 | SPARK-43578のTODOコメント存在 | E-02 (33-34行目) | ○ |
| C-13 | equals/hashCodeのオーバーライド | E-01 (146-175行目), E-02 (59-88行目) | ○ |
| C-14 | from_protobufのprettyNameが"from_protobuf" | E-01 (122行目) | ○ |
| C-15 | to_protobufのprettyNameが"to_protobuf" | E-02 (49行目) | ○ |
| C-16 | emitDefaultValues/enumsAsIntsオプション | E-01 (67-68行目) | ○ |
| C-17 | DynamicMessageがJavaクラス生成より低速 | **根拠なし（コメントのみ）** | △ |

## 4) 不足情報（Unknown / Missing）
- DynamicMessage vs Javaクラス生成のパフォーマンス比較データ
  - 候補：ベンチマーク結果 / Protobufドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: from_protobuf/to_protobufの処理フロー - ソースコードと完全一致
- 0: エラー処理の記述 - ソースコードと一致
- 1: パフォーマンス記述 - コードコメント（SPARK-43578）に基づく推測あり

## 6) レビュアーチェックリスト（最小）
- [ ] from_protobuf/to_protobufの処理フローが正確か
- [ ] Unknown Fields検証のロジック記述が正しいか
- [ ] TypeRegistry構築の条件分岐が正しいか
- [ ] パフォーマンスに関する記述の妥当性
