---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 12
  claims_without_evidence: 3
confidence_derived: 0.80
---

# 根拠レポート：36-ストリーム処理エンジン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：12 / 15、根拠なし：3
- 優先レビュー（高）
  1. **MicroBatchExecution.runActivatedStreamの詳細フロー**：ファイル内容未詳細確認
  2. **IncrementalExecutionの最適化ルール**：ファイル内容未詳細確認
  3. **ウォーターマーク計算の具体的ロジック**：実装詳細未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/runtime/` (ディレクトリ一覧)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | StreamExecution.scalaが基底クラス | E-01 (ファイル存在) | ○ |
| C-02 | MicroBatchExecution.scalaの存在 | E-01 (ファイル存在) | ○ |
| C-03 | AsyncProgressTrackingMicroBatchExecution.scalaの存在 | E-01 (ファイル存在) | ○ |
| C-04 | IncrementalExecution.scalaの存在 | E-01 (ファイル存在) | ○ |
| C-05 | ProgressReporter.scalaの存在 | E-01 (ファイル存在) | ○ |
| C-06 | WatermarkTracker/WatermarkPropagatorの存在 | E-01 (ファイル存在) | ○ |
| C-07 | TriggerExecutor.scalaの存在 | E-01 (ファイル存在) | ○ |
| C-08 | 画面16/17との関連 | E-03 (該当行) | ○ |
| C-09 | 機能一覧での機能説明 | E-02 (37行目) | ○ |
| C-10 | Exactly-once処理保証 | E-02 (機能説明) | ○ |
| C-11 | マイクロバッチと連続処理モード | E-02 (機能説明) | ○ |
| C-12 | チェックポイントによる障害復旧 | E-02 (機能説明) | ○ |
| C-13 | MicroBatchExecution.runActivatedStreamの詳細フロー | **根拠なし（ファイル未詳細読解）** | △ |
| C-14 | IncrementalExecutionの最適化ルール詳細 | **根拠なし（ファイル未詳細読解）** | △ |
| C-15 | ウォーターマーク計算式 | **根拠なし（実装未詳細確認）** | △ |

## 4) 不足情報（Unknown / Missing）
- MicroBatchExecution.scalaの詳細実装
  - 候補：MicroBatchExecution.scala の詳細読解
- IncrementalExecution.scalaの最適化ルール
  - 候補：IncrementalExecution.scala の詳細読解
- WatermarkTracker.scalaの計算ロジック
  - 候補：WatermarkTracker.scala の詳細読解

## 5) リスクフラグ（レビュー観点）
- 0: ファイル構成と役割分担 - ディレクトリ一覧と一致
- 1: 処理フローの詳細 - 一般的な設計知識に基づく記述あり
- 1: ウォーターマーク計算 - 一般的なStructured Streaming知識に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] MicroBatchExecution.runActivatedStreamの実際のフローと記述が一致するか
- [ ] IncrementalExecutionの最適化ルールの記述が正確か
- [ ] ウォーターマーク計算式の記述が正しいか
- [ ] 画面16/17との関連記述が正しいか
