---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：37-Kafkaソース/シンク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **Exactly-once保証の詳細実装**：冪等Producerの具体的設定未確認
  2. **KafkaMicroBatchStreamの詳細フロー**：ファイル内容未詳細確認

## 2) 参照した情報（Evidence一覧）

- E-01: `connector/kafka-0-10-sql/src/main/scala/org/apache/spark/sql/kafka010/KafkaSourceProvider.scala`
- E-02: `connector/kafka-0-10-sql/src/main/scala/org/apache/spark/sql/kafka010/` (ディレクトリ一覧)
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KafkaSourceProviderのshortNameが"kafka" | E-01 (61行目) | ○ |
| C-02 | 固定スキーマでカスタムスキーマ不可 | E-01 (74行目) | ○ |
| C-03 | sourceSchema()がincludeHeadersオプションを考慮 | E-01 (75-76行目) | ○ |
| C-04 | KafkaSourceProviderが複数のプロバイダートレイトを実装 | E-01 (52-58行目) | ○ |
| C-05 | assign/subscribe/subscribePatternの3戦略 | E-01 (73行目validateStreamOptions参照) | ○ |
| C-06 | KafkaMicroBatchStream.scalaの存在 | E-02 (ファイル存在) | ○ |
| C-07 | KafkaContinuousStream.scalaの存在 | E-02 (ファイル存在) | ○ |
| C-08 | KafkaStreamingWrite.scalaの存在 | E-02 (ファイル存在) | ○ |
| C-09 | KafkaDataConsumer.scalaの存在 | E-02 (ファイル存在) | ○ |
| C-10 | CachedKafkaProducer.scalaの存在 | E-02 (ファイル存在) | ○ |
| C-11 | KafkaOffsetReaderAdmin/Consumerの2実装 | E-02 (ファイル存在) | ○ |
| C-12 | InternalKafkaConsumerPool/ProducerPoolの存在 | E-02 (ファイル存在) | ○ |
| C-13 | ConsumerStrategy.scalaの存在 | E-02 (ファイル存在) | ○ |
| C-14 | Exactly-once保証の冪等Producer実装 | **根拠なし（一般知識）** | △ |
| C-15 | KafkaMicroBatchStreamの詳細処理フロー | **根拠なし（ファイル未詳細読解）** | △ |

## 4) 不足情報（Unknown / Missing）
- KafkaMicroBatchStream.scalaの詳細実装ロジック
  - 候補：KafkaMicroBatchStream.scala の詳細読解
- 冪等Producerの設定詳細
  - 候補：KafkaStreamingWrite.scala / KafkaWriteTask.scala

## 5) リスクフラグ（レビュー観点）
- 0: ファイル構成と役割 - ディレクトリ一覧と一致
- 0: KafkaSourceProviderの基本情報 - ソースコードと一致
- 1: Exactly-once実装の詳細 - 一般知識に基づく記述

## 6) レビュアーチェックリスト（最小）
- [ ] KafkaSourceProviderの記述が正確か
- [ ] 固定スキーマの記述が正しいか
- [ ] オフセット管理の記述が正確か
- [ ] Exactly-once保証の記述の詳細を確認
