---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：4-タスクスケジューラ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **遅延スケジューリングのデフォルト待機時間3秒**：設定ファイルでの確認が必要
  2. **投機的実行チェック間隔のデフォルト100ms**：設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/scheduler/TaskSchedulerImpl.scala` 46-82行目 - Scaladoc
- E-02: `core/src/main/scala/org/apache/spark/scheduler/TaskSchedulerImpl.scala` 83-88行目 - クラス定義
- E-03: `core/src/main/scala/org/apache/spark/scheduler/TaskSchedulerImpl.scala` 92-93行目 - デフォルトコンストラクタ
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 5行目 - 機能定義
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連
- E-06: `core/src/main/scala/org/apache/spark/scheduler/TaskLocality.scala` - ローカリティ定義
- E-07: `core/src/main/scala/org/apache/spark/scheduler/SchedulingMode.scala` - スケジューリングモード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TaskSchedulerImplがDAGSchedulerからTaskSetを受信 | E-01 | ○ |
| C-02 | データローカリティ最適化（PROCESS→NODE→RACK→ANY） | E-01, E-06 | ○ |
| C-03 | 遅延スケジューリングによるローカリティ改善 | E-01 | ○ |
| C-04 | FIFO/FAIRスケジューリングポリシー | E-07 | ○ |
| C-05 | マルチスレッド安全性（synchronized） | E-01 | ○ |
| C-06 | 投機的タスク実行 | E-01 | ○ |
| C-07 | タスク最大失敗回数spark.task.maxFailures | E-03 | ○ |
| C-08 | HealthTrackerによるブロックリスト管理 | E-02 | ○ |
| C-09 | 画面3,4,5との関連 | E-05 | ○ |
| C-10 | SchedulerBackendがクラスタマネージャ固有の実装を提供 | E-01 | ○ |
| C-11 | FAIRスケジューラはfairscheduler.xml設定ファイルで定義 | E-01 | ○ |
| C-12 | resourceOffers()でExecutorリソースを割り当て | E-01 | ○ |
| C-13 | statusUpdate()でタスク完了/失敗を処理 | E-01 | ○ |
| C-14 | 遅延スケジューリングのデフォルト待機時間は3秒 | **根拠なし** | △ |
| C-15 | 投機的実行チェック間隔のデフォルトは100ms | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: spark.locality.waitのデフォルト値はconfigパッケージで確認が必要
  - 候補：`internal/config/package.scala` / 公式設定ドキュメント
- C-15: spark.speculation.intervalのデフォルト値はconfigパッケージで確認が必要
  - 候補：`internal/config/package.scala` / 公式設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: TaskSchedulerの基本設計とスレッディングモデル - Scaladocから確認済み
- 0: データローカリティレベルの順序 - ソースコードから確認済み
- 1: 設定パラメータのデフォルト値 - configパッケージの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] ローカリティレベルの順序が正確か
- [ ] 遅延スケジューリングのデフォルト値が正確か
- [ ] 投機的実行のデフォルト設定値が正確か
- [ ] 画面関連マッピングが画面機能マッピング.csvと一致しているか
