---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：41-レシーバー管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **HDFS書き込み権限要件**：セキュリティ要件として推定した内容で、コード上に明示的な権限チェックは確認されない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `streaming/src/main/scala/org/apache/spark/streaming/receiver/Receiver.scala`
- E-02: `streaming/src/main/scala/org/apache/spark/streaming/receiver/ReceiverSupervisor.scala`
- E-03: `streaming/src/main/scala/org/apache/spark/streaming/receiver/ReceiverSupervisorImpl.scala`
- E-04: `streaming/src/main/scala/org/apache/spark/streaming/receiver/BlockGenerator.scala`
- E-05: `streaming/src/main/scala/org/apache/spark/streaming/receiver/ReceivedBlockHandler.scala`
- E-06: `streaming/src/main/scala/org/apache/spark/streaming/receiver/ReceivedBlock.scala`
- E-07: `streaming/src/main/scala/org/apache/spark/streaming/receiver/ReceiverMessage.scala`
- E-08: `streaming/src/main/scala/org/apache/spark/streaming/receiver/RateLimiter.scala`
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 行42
- E-10: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 行68

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Receiverは外部データソースからデータを受信する抽象クラス | E-01 (86行目) | ○ |
| C-02 | onStart()とonStop()を実装してカスタムレシーバーを定義 | E-01 (102,108行目) | ○ |
| C-03 | store()メソッドでSupervisorにデータを委譲 | E-01 (118-180行目) | ○ |
| C-04 | レシーバー状態はInitialized/Started/Stoppedの3値 | E-02 (43-46行目) | ○ |
| C-05 | defaultRestartDelayのデフォルトは2000ms | E-02 (62行目) | ○ |
| C-06 | restart()は非同期Futureで実行される | E-02 (192-204行目) | ○ |
| C-07 | WAL有効時はWriteAheadLogBasedBlockHandlerが選択される | E-03 (56-68行目) | ○ |
| C-08 | RPCエンドポイントでStopReceiver/CleanupOldBlocks/UpdateRateLimitを受信 | E-03 (79-91行目) | ○ |
| C-09 | pushAndReportBlockでブロック格納とReceiverTrackerへの報告を行う | E-03 (151-166行目) | ○ |
| C-10 | BlockGeneratorは5つの状態を持つ | E-04 (88-103行目) | ○ |
| C-11 | blockIntervalMsでブロック生成間隔を制御 | E-04 (105行目) | ○ |
| C-12 | blockQueueSizeのデフォルトは10 | E-04 (110行目) | ○ |
| C-13 | addData()でRateLimiter.waitToPush()後にバッファ追加 | E-04 (165-180行目) | ○ |
| C-14 | keepPushingBlocks()でキューからブロックを取出して格納 | E-04 (262-294行目) | ○ |
| C-15 | ReceivedBlockは3種類（ArrayBufferBlock, IteratorBlock, ByteBufferBlock） | E-06 (26-34行目) | ○ |
| C-16 | ReceiverMessageは3種類（StopReceiver, CleanupOldBlocks, UpdateRateLimit） | E-07 (23-27行目) | ○ |
| C-17 | RateLimiterはGuava RateLimiterをラップ | E-08 (20,42行目) | ○ |
| C-18 | updateRate()でmaxRateLimitを上限とする | E-08 (59-66行目) | ○ |
| C-19 | WAL有効時はdeserialized=false, replication=1に強制変更 | E-05 (139-152行目) | ○ |
| C-20 | WALのblockStoreTimeoutデフォルトは30秒 | E-05 (136-137行目) | ○ |
| C-21 | WALはBlockManagerとWALに並列書き込み（2スレッド） | E-05 (166-167行目) | ○ |
| C-22 | RegisterReceiverでドライバーに登録 | E-03 (190-194行目) | ○ |
| C-23 | DeregisterReceiverで登録解除 | E-03 (196-201行目) | ○ |
| C-24 | 関連画面はStreaming Overview（画面No.18） | E-10 (68行目) | ○ |
| C-25 | WAL利用時にはチェックポイントディレクトリへのHDFS書き込み権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: HDFS書き込み権限要件はアーキテクチャ上の推定であり、コード上にHDFS権限チェック処理は明示されていない
  - 候補：Hadoop FileSystem API仕様 / Sparkセキュリティドキュメント / HDFS権限モデル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードリーディングガイドの行番号は実際のソースコードと一致している
- 0: 低リスク - 設定パラメータのデフォルト値はソースコードから直接確認済み
- 1: 中リスク - セキュリティ考慮事項のHDFS権限要件は推定に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] BlockGenerator状態遷移の5段階が正しく記載されているか確認
- [ ] WAL有効時のストレージレベル調整ロジックが正確か確認
- [ ] RateLimiterの初期レート計算式が正しいか確認
- [ ] ReceiverTrackerとの通信プロトコル（RegisterReceiver等）が最新のコードと一致しているか確認
