---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：45-ランダムフォレスト分類

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全主張が根拠により裏付けられている

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/classification/RandomForestClassifier.scala`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 行46

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProbabilisticClassifierを継承 | E-01 (49行目) | ○ |
| C-02 | train()でRandomForest.run呼び出し | E-01 (168-169行目) | ○ |
| C-03 | bootstrap設定をstrategyに適用 | E-01 (161行目) | ○ |
| C-04 | Instance RDD作成（ラベル・重み・特徴量チェック） | E-01 (152-157行目) | ○ |
| C-05 | predictRaw()で全木の投票値集約 | E-01 (315-332行目) | ○ |
| C-06 | classCounts/totalで各木の確率を計算 | E-01 (321-329行目) | ○ |
| C-07 | raw2probabilityInPlace()で確率正規化 | E-01 (334-343行目) | ○ |
| C-08 | featureImportancesは全木の平均 | E-01 (368行目) | ○ |
| C-09 | モデルサマリー（Binary/Multiclass分岐） | E-01 (379-400行目) | ○ |
| C-10 | evaluate()メソッド | E-01 (279-290行目) | ○ |
| C-11 | 最低1本の木が必要 | E-01 (227行目) | ○ |
| C-12 | 全木の重みは均一（1.0） | E-01 (249行目) | ○ |
| C-13 | leafColサポート | E-01 (301-312行目) | ○ |
| C-14 | モデル永続化（numFeatures, numClasses, numTreesを保存） | E-01 (425-428行目) | ○ |
| C-15 | supportedImpurities: entropy, gini | E-01 (197行目) | ○ |
| C-16 | supportedFeatureSubsetStrategies | E-01 (201-202行目) | ○ |
| C-17 | binarySummaryメソッド | E-01 (266-271行目) | ○ |
| C-18 | 機能一覧にランダムフォレスト分類として定義 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報はなし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで直接確認されている

## 6) レビュアーチェックリスト（最小）
- [ ] predictRaw()の投票集約ロジックが正確か確認
- [ ] サマリー分岐（Binary/Multiclass）の条件が正しいか確認
- [ ] モデル永続化の読み込み時のnumTrees検証が正しいか確認
