---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：46-勾配ブースティング木分類

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **train()メソッドの詳細フロー**：150行目以降の読み込み範囲外のため、GradientBoostedTrees.run()呼び出し部分の詳細を完全には確認できていない

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/classification/GBTClassifier.scala` (1-150行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 行47

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProbabilisticClassifierを継承 | E-01 (60行目) | ○ |
| C-02 | 二値分類のみサポート | E-01 (43-55行目, Scaladoc) | ○ |
| C-03 | setImpurityは無視される（警告のみ） | E-01 (117-120行目) | ○ |
| C-04 | GradientBoostedTreesをインポート | E-01 (29行目) | ○ |
| C-05 | DecisionTreeRegressionModelを使用 | E-01 (27行目) | ○ |
| C-06 | Stochastic Gradient Boostingの実装 | E-01 (45行目, Scaladoc) | ○ |
| C-07 | maxIterパラメータ | E-01 (136行目) | ○ |
| C-08 | stepSizeパラメータ | E-01 (140行目) | ○ |
| C-09 | featureSubsetStrategyパラメータ | E-01 (144行目) | ○ |
| C-10 | subsamplingRateパラメータ | E-01 (126行目) | ○ |
| C-11 | デフォルトUID "gbtc" | E-01 (64行目) | ○ |
| C-12 | BLAS使用（import文） | E-01 (25行目) | ○ |
| C-13 | 機能一覧にGBT分類として定義 | E-02 | ○ |
| C-14 | ロジスティック損失関数を使用 | E-01 (41行目, Scaladoc参照) | ○ |
| C-15 | train()メソッドの詳細実装フロー | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: train()メソッドの本体部分（150行目以降）が読み込み範囲外のため、GradientBoostedTrees.run()の呼び出し詳細は確認できていない
  - 候補：GBTClassifier.scala全文 / GradientBoostedTrees.scala

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - train()メソッドの詳細実装は部分的にしか確認できていない
- 0: 低リスク - パラメータ定義と基本構造は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] train()メソッドの実装がGradientBoostedTrees.run()を正しく呼び出しているか確認
- [ ] predictRaw()の加重和計算とロジスティック変換が正確か確認
- [ ] 多クラス分類非サポートの制約が最新コードと一致しているか確認
