---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：47-線形SVM

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **train()メソッドの詳細フロー**：150行目以降の読み込み範囲外

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/classification/LinearSVC.scala` (1-150行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 行48

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Classifierを継承（ProbabilisticClassifierではない） | E-01 (83行目) | ○ |
| C-02 | ヒンジ損失をOWLQNで最適化 | E-01 (25行目, import BreezeOWLQN; 72行目, Scaladoc) | ○ |
| C-03 | L2正則化のみサポート | E-01 (73行目, Scaladoc) | ○ |
| C-04 | thresholdはrawPredictionに適用 | E-01 (53-56行目) | ○ |
| C-05 | thresholdデフォルト値0.0 | E-01 (64行目) | ○ |
| C-06 | regParamデフォルト0.0 | E-01 (64行目) | ○ |
| C-07 | maxIterデフォルト100 | E-01 (64行目) | ○ |
| C-08 | fitInterceptデフォルトtrue | E-01 (64行目) | ○ |
| C-09 | tolデフォルト1E-6 | E-01 (64行目) | ○ |
| C-10 | standardizationデフォルトtrue | E-01 (65行目) | ○ |
| C-11 | aggregationDepthデフォルト2 | E-01 (65行目) | ○ |
| C-12 | maxBlockSizeInMBデフォルト0.0 | E-01 (65行目) | ○ |
| C-13 | Spark 3.1.0以降でブロックスタッキング対応 | E-01 (76-77行目, Scaladoc) | ○ |
| C-14 | 機能一覧に線形SVMとして定義 | E-02 | ○ |
| C-15 | train()メソッドの詳細実装 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: train()メソッド本体（150行目以降）が読み込み範囲外
  - 候補：LinearSVC.scala全文 / HingeAggregator.scala

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - train()の詳細実装は部分的にしか確認できていない
- 0: 低リスク - パラメータ定義とデフォルト値は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] train()メソッドのOWLQN最適化呼び出しが正確か確認
- [ ] predict()のthreshold適用ロジックが正確か確認
- [ ] L2正則化の実装が正しいか確認
