---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：48-ナイーブベイズ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **trainWithLabelCheck()の詳細実装**：150行目以降の内部ロジック

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/classification/NaiveBayes.scala` (1-150行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 行49

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProbabilisticClassifierを継承 | E-01 (100行目) | ○ |
| C-02 | smoothingパラメータデフォルト1.0 | E-01 (51,71行目) | ○ |
| C-03 | modelType: multinomial/complement/bernoulli/gaussian | E-01 (63-66行目) | ○ |
| C-04 | modelTypeデフォルト"multinomial" | E-01 (71行目) | ○ |
| C-05 | train()がtrainWithLabelCheck委譲 | E-01 (135-137行目) | ○ |
| C-06 | nonNegativeLabel=true | E-01 (136行目) | ○ |
| C-07 | Multinomial NB: TF-IDFに適用可能 | E-01 (78-80行目, Scaladoc) | ○ |
| C-08 | Bernoulli NB: 二値データに適用 | E-01 (82-84行目, Scaladoc) | ○ |
| C-09 | Complement NB: 補集合統計量使用 | E-01 (86-90行目, Scaladoc) | ○ |
| C-10 | Gaussian NB: 連続データに対応 | E-01 (91-94行目, Scaladoc) | ○ |
| C-11 | Spark 3.0.0でComplement/Gaussian追加 | E-01 (86,91行目, @Since) | ○ |
| C-12 | weightCol対応 | E-01 (131-133行目) | ○ |
| C-13 | smoothingのバリデーション（0以上） | E-01 (52行目) | ○ |
| C-14 | setSmoothing/setModelType設定メソッド | E-01 (113-123行目) | ○ |
| C-15 | 機能一覧にナイーブベイズとして定義 | E-02 | ○ |
| C-16 | trainWithLabelCheck内の詳細パラメータ推定ロジック | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: trainWithLabelCheck()の内部実装（150行目以降）が読み込み範囲外
  - 候補：NaiveBayes.scala全文

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - パラメータ推定ロジックの詳細は部分的にしか確認できていない
- 0: 低リスク - パラメータ定義とモデルタイプの仕様は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各モデルタイプのパラメータ推定ロジックが正確か確認
- [ ] Gaussian NBの平均・分散推定が正しいか確認
- [ ] predictRaw()の対数尤度計算が正しいか確認
